/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.filesexist;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.w3c.dom.Node;

@Action(id="FILES_EXIST", name="i18n::ActionFilesExist.Name", description="i18n::ActionFilesExist.Description", image="FilesExist.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionFilesExist.keyword"}, documentationUrl="/workflow/actions/filesexist.html")
public class ActionFilesExist
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionFilesExist.class;
    private String filename = null;
    private String[] arguments;

    public ActionFilesExist(String n) {
        super(n, "");
    }

    public ActionFilesExist() {
        this("");
    }

    public void allocate(int nrFields) {
        this.arguments = new String[nrFields];
    }

    public Object clone() {
        ActionFilesExist je = (ActionFilesExist)super.clone();
        if (this.arguments != null) {
            int nrFields = this.arguments.length;
            je.allocate(nrFields);
            System.arraycopy(this.arguments, 0, je.arguments, 0, nrFields);
        }
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(30);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionFilesExist.ERROR_0001_Cannot_Load_Workflow_Action_From_Xml_Node", (String[])new String[]{xe.getMessage()}));
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(0L);
        int missingfiles = 0;
        int nrErrors = 0;
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length && !this.parentWorkflow.isStopped(); ++i) {
                FileObject file = null;
                try {
                    String realFilefoldername = this.resolve(this.arguments[i]);
                    file = HopVfs.getFileObject((String)realFilefoldername, (IVariables)this.getVariables());
                    if (file.exists() && file.isReadable()) {
                        if (!this.isDetailed()) continue;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFilesExist.File_Exists", (String[])new String[]{realFilefoldername}));
                        continue;
                    }
                    ++missingfiles;
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFilesExist.File_Does_Not_Exist", (String[])new String[]{realFilefoldername}));
                    continue;
                }
                catch (Exception e) {
                    ++nrErrors;
                    ++missingfiles;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFilesExist.ERROR_0004_IO_Exception", (String[])new String[]{e.toString()}), e);
                    continue;
                }
                finally {
                    if (file != null) {
                        try {
                            file.close();
                            file = null;
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        result.setNrErrors((long)nrErrors);
        if (missingfiles == 0) {
            result.setResult(true);
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
    }
}

