/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ActionCompletedEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEvent;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.swing.Icon;
import javax.swing.JButton;

public class SQLStatementButton
extends JButton
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    transient ActionCompletedEventSupport actionListeners_ = new ActionCompletedEventSupport(this);
    transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);
    transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);
    SQLConnection connection_ = null;
    String sql_ = null;
    transient SQLWarning warnings_ = null;
    transient Statement statement_ = null;

    public SQLStatementButton() {
        this.addActionListener(new ButtonListener_());
    }

    public SQLStatementButton(Icon icon) {
        super(icon);
        this.addActionListener(new ButtonListener_());
    }

    public SQLStatementButton(String text) {
        super(text);
        this.addActionListener(new ButtonListener_());
    }

    public SQLStatementButton(String text, Icon icon) {
        super(text, icon);
        this.addActionListener(new ButtonListener_());
    }

    public SQLStatementButton(String text, Icon icon, SQLConnection connection, String SQLStatement) {
        super(text, icon);
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection_ = connection;
        if (SQLStatement == null) {
            throw new NullPointerException("SQLStatement");
        }
        this.sql_ = SQLStatement;
        this.addActionListener(new ButtonListener_());
    }

    public void addActionCompletedListener(ActionCompletedListener listener) {
        this.actionListeners_.addActionCompletedListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners_.addErrorListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingListeners_.addWorkingListener(listener);
    }

    public SQLConnection getConnection() {
        return this.connection_;
    }

    public void getMoreResults() {
        if (this.statement_ != null) {
            this.workingListeners_.fireStartWorking();
            try {
                this.statement_.getMoreResults();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
            this.workingListeners_.fireStopWorking();
        }
    }

    public ResultSet getResultSet() {
        if (this.statement_ == null) {
            return null;
        }
        this.workingListeners_.fireStartWorking();
        ResultSet result = null;
        try {
            result = this.statement_.getResultSet();
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
        }
        this.workingListeners_.fireStopWorking();
        return result;
    }

    public String getSQLStatement() {
        if (this.sql_ == null) {
            return "";
        }
        return this.sql_;
    }

    public int getUpdateCount() {
        if (this.statement_ == null) {
            return -1;
        }
        try {
            return this.statement_.getUpdateCount();
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
            return 0;
        }
    }

    public SQLWarning getWarnings() {
        if (this.statement_ == null) {
            return null;
        }
        SQLWarning s_warnings = null;
        try {
            s_warnings = this.statement_.getWarnings();
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
        }
        if (this.warnings_ != null) {
            SQLWarning next;
            if (s_warnings == null) {
                return this.warnings_;
            }
            SQLWarning last = this.warnings_;
            while ((next = last.getNextWarning()) != null) {
                last = next;
            }
            last.setNextWarning(s_warnings);
            return this.warnings_;
        }
        return s_warnings;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.actionListeners_ = new ActionCompletedEventSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
        this.worker_ = new WorkingCursorAdapter(this);
        this.warnings_ = null;
        this.statement_ = null;
        this.addActionListener(new ButtonListener_());
    }

    public void removeActionCompletedListener(ActionCompletedListener listener) {
        this.actionListeners_.removeActionCompletedListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners_.removeErrorListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingListeners_.removeWorkingListener(listener);
    }

    public void setConnection(SQLConnection connection) throws PropertyVetoException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.fireVetoableChange("connection", this.connection_, connection);
        SQLConnection old = this.connection_;
        this.connection_ = connection;
        if (old != connection) {
            if (this.statement_ != null) {
                try {
                    this.statement_.close();
                }
                catch (SQLException e) {
                    this.errorListeners_.fireError(e);
                }
            }
            this.statement_ = null;
            this.warnings_ = null;
        }
        this.firePropertyChange("connection", old, this.connection_);
    }

    public void setSQLStatement(String SQLStatement) throws PropertyVetoException {
        if (SQLStatement == null) {
            throw new NullPointerException("SQLStatement");
        }
        String old = this.getSQLStatement();
        this.fireVetoableChange("SQLStatement", old, SQLStatement);
        this.sql_ = SQLStatement;
        this.firePropertyChange("SQLStatement", old, this.sql_);
    }

    private class ButtonListener_
    implements ActionListener {
        private ButtonListener_() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (SQLStatementButton.this.connection_ == null) {
                IllegalStateException e = new IllegalStateException("connection");
                SQLStatementButton.this.errorListeners_.fireError(e);
                return;
            }
            if (SQLStatementButton.this.sql_ == null) {
                IllegalStateException e = new IllegalStateException("SQLStatement");
                SQLStatementButton.this.errorListeners_.fireError(e);
                return;
            }
            Trace.log(3, "Running button, sql is:  " + SQLStatementButton.this.sql_);
            SQLStatementButton.this.workingListeners_.fireStartWorking();
            SQLStatementButton.this.worker_.startWorking(new WorkingEvent(this));
            if (SQLStatementButton.this.statement_ == null) {
                Connection conn;
                try {
                    conn = SQLStatementButton.this.connection_.getConnection();
                    SQLStatementButton.this.statement_ = conn.createStatement();
                }
                catch (SQLException e) {
                    SQLStatementButton.this.errorListeners_.fireError(e);
                    SQLStatementButton.this.worker_.stopWorking(new WorkingEvent(this));
                    SQLStatementButton.this.workingListeners_.fireStopWorking();
                    return;
                }
                try {
                    SQLStatementButton.this.warnings_ = conn.getWarnings();
                }
                catch (SQLException e) {
                    SQLStatementButton.this.errorListeners_.fireError(e);
                }
            } else {
                SQLStatementButton.this.warnings_ = null;
                try {
                    SQLStatementButton.this.statement_.clearWarnings();
                }
                catch (SQLException e) {
                    SQLStatementButton.this.errorListeners_.fireError(e);
                }
            }
            try {
                SQLStatementButton.this.statement_.execute(SQLStatementButton.this.sql_);
            }
            catch (SQLException e) {
                SQLStatementButton.this.errorListeners_.fireError(e);
            }
            SQLStatementButton.this.actionListeners_.fireActionCompleted();
            SQLStatementButton.this.worker_.stopWorking(new WorkingEvent(this));
            SQLStatementButton.this.workingListeners_.fireStopWorking();
        }
    }
}

