/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.File;
import java.io.IOException;
import org.apache.flink.util.FileUtils;

public class WorkingDirectory {
    private final File root;
    private final File tmp;
    private final File localState;
    private final File blobStorage;
    private final File slotAllocationSnapshotDirectory;

    private WorkingDirectory(File root) throws IOException {
        this.root = root;
        WorkingDirectory.createDirectory(root);
        this.tmp = new File(root, "tmp");
        WorkingDirectory.createDirectory(this.tmp);
        FileUtils.cleanDirectory((File)this.tmp);
        this.localState = new File(root, "localState");
        WorkingDirectory.createDirectory(this.localState);
        this.blobStorage = new File(root, "blobStorage");
        WorkingDirectory.createDirectory(this.blobStorage);
        this.slotAllocationSnapshotDirectory = new File(root, "slotAllocationSnapshots");
        WorkingDirectory.createDirectory(this.slotAllocationSnapshotDirectory);
    }

    private static void createDirectory(File directory) throws IOException {
        if (!directory.mkdirs() && !directory.exists()) {
            throw new IOException(String.format("Could not create the working directory %s.", directory));
        }
    }

    public void delete() throws IOException {
        FileUtils.deleteDirectory((File)this.root);
    }

    public File getTmpDirectory() {
        return this.tmp;
    }

    public File getLocalStateDirectory() {
        return this.localState;
    }

    public File getSlotAllocationSnapshotDirectory() {
        return this.slotAllocationSnapshotDirectory;
    }

    public WorkingDirectory createSubWorkingDirectory(String directoryName) throws IOException {
        return WorkingDirectory.createIn(this.root, directoryName);
    }

    public String toString() {
        return String.format("WorkingDirectory(%s)", this.root.toString());
    }

    public static WorkingDirectory create(File workingDirectory) throws IOException {
        return new WorkingDirectory(workingDirectory);
    }

    public static WorkingDirectory createIn(File parentDirectory, String directoryName) throws IOException {
        return WorkingDirectory.create(new File(parentDirectory, directoryName));
    }

    public File getBlobStorageDirectory() {
        return this.blobStorage;
    }
}

