/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.transforms.DoFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessingMetricsDoFn
extends DoFn<DataChangeRecord, DataChangeRecord>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -1515578871387565606L;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PostProcessingMetricsDoFn.class);
    private static final @UnknownKeyFor @NonNull @Initialized long COMMITTED_TO_EMITTED_THRESHOLD_MS = 100000L;
    private static final @UnknownKeyFor @NonNull @Initialized long STREAM_THRESHOLD_MS = 5000L;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;

    public PostProcessingMetricsDoFn(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics) {
        this.metrics = metrics;
    }

    @DoFn.ProcessElement
    public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized DataChangeRecord dataChangeRecord, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized DataChangeRecord> receiver) {
        Instant commitInstant = new Instant(dataChangeRecord.getCommitTimestamp().toSqlTimestamp().getTime());
        this.metrics.incDataRecordCounter();
        this.measureCommitTimestampToEmittedMillis(dataChangeRecord);
        this.measureStreamMillis(dataChangeRecord);
        receiver.outputWithTimestamp((Object)dataChangeRecord, commitInstant);
    }

    private void measureCommitTimestampToEmittedMillis(@UnknownKeyFor @NonNull @Initialized DataChangeRecord dataChangeRecord) {
        Timestamp emittedTimestamp = Timestamp.now();
        Timestamp commitTimestamp = dataChangeRecord.getCommitTimestamp();
        Duration committedToEmitted = new Duration(commitTimestamp.toSqlTimestamp().getTime(), emittedTimestamp.toSqlTimestamp().getTime());
        long commitedToEmittedMillis = committedToEmitted.getMillis();
        this.metrics.updateDataRecordCommittedToEmitted(committedToEmitted);
        if (commitedToEmittedMillis > 100000L) {
            LOG.debug("Data record took {}ms to be emitted: {}", (Object)commitedToEmittedMillis, (Object)dataChangeRecord.getMetadata());
        }
    }

    private void measureStreamMillis(@UnknownKeyFor @NonNull @Initialized DataChangeRecord dataChangeRecord) {
        ChangeStreamRecordMetadata metadata = dataChangeRecord.getMetadata();
        Timestamp streamStartedAt = metadata.getRecordStreamStartedAt();
        Timestamp streamEndedAt = metadata.getRecordStreamEndedAt();
        Duration streamDuration = new Duration(streamStartedAt.toSqlTimestamp().getTime(), streamEndedAt.toSqlTimestamp().getTime());
        long streamMillis = streamDuration.getMillis();
        if (streamMillis > 5000L) {
            LOG.debug("Data record took {}ms to be streamed: {}", (Object)streamMillis, (Object)metadata);
        }
    }
}

