/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.parser;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.core.org.antlr.v4.runtime.CharStreams;
import org.apache.beam.repackaged.core.org.antlr.v4.runtime.CodePointCharStream;
import org.apache.beam.repackaged.core.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.parser.generated.FieldSpecifierNotationBaseVisitor;
import org.apache.beam.sdk.schemas.parser.generated.FieldSpecifierNotationLexer;
import org.apache.beam.sdk.schemas.parser.generated.FieldSpecifierNotationParser;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class FieldAccessDescriptorParser {
    public static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor parse(@UnknownKeyFor @NonNull @Initialized String expr) {
        CodePointCharStream charStream = CharStreams.fromString(expr);
        FieldSpecifierNotationLexer lexer = new FieldSpecifierNotationLexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        FieldSpecifierNotationParser parser = new FieldSpecifierNotationParser(tokens);
        return (FieldAccessDescriptor)new BuildFieldAccessDescriptor().visit(parser.dotExpression());
    }

    private static class QualifierVisitor
    extends FieldSpecifierNotationBaseVisitor<FieldAccessDescriptor> {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers = Lists.newArrayList();

        private QualifierVisitor() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized FieldAccessDescriptor visitArrayQualifierList(@UnknownKeyFor @NonNull @Initialized FieldSpecifierNotationParser.ArrayQualifierListContext ctx) {
            this.qualifiers.add(FieldAccessDescriptor.FieldDescriptor.Qualifier.of(FieldAccessDescriptor.FieldDescriptor.ListQualifier.ALL));
            ctx.qualifierList().forEach(subList -> subList.accept(this));
            return null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized FieldAccessDescriptor visitMapQualifierList(@UnknownKeyFor @NonNull @Initialized FieldSpecifierNotationParser.MapQualifierListContext ctx) {
            this.qualifiers.add(FieldAccessDescriptor.FieldDescriptor.Qualifier.of(FieldAccessDescriptor.FieldDescriptor.MapQualifier.ALL));
            ctx.qualifierList().forEach(subList -> subList.accept(this));
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor.FieldDescriptor.Qualifier> getQualifiers() {
            return this.qualifiers;
        }
    }

    private static class BuildFieldAccessDescriptor
    extends FieldSpecifierNotationBaseVisitor<FieldAccessDescriptor> {
        private BuildFieldAccessDescriptor() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor visitFieldSpecifier(@UnknownKeyFor @NonNull @Initialized FieldSpecifierNotationParser.FieldSpecifierContext ctx) {
            return ctx.dotExpression().accept(this);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor visitDotExpression(@UnknownKeyFor @NonNull @Initialized FieldSpecifierNotationParser.DotExpressionContext ctx) {
            List components = ctx.dotExpressionComponent().stream().map(dotE -> dotE.accept(this)).collect(Collectors.toList());
            Preconditions.checkArgument((!components.isEmpty() ? 1 : 0) != 0);
            FieldAccessDescriptor fieldAccessDescriptor = (FieldAccessDescriptor)components.get(components.size() - 1);
            for (int i = components.size() - 2; i >= 0; --i) {
                FieldAccessDescriptor component = (FieldAccessDescriptor)components.get(i);
                if (component.getAllFields()) {
                    throw new IllegalArgumentException("We currently only support wildcards at terminal parts of selectors. 'x.*' is allowed, but x.*.y is not currently allowed.");
                }
                FieldAccessDescriptor.FieldDescriptor fieldAccessed = (FieldAccessDescriptor.FieldDescriptor)component.getFieldsAccessed().stream().findFirst().orElseThrow(IllegalArgumentException::new);
                fieldAccessDescriptor = FieldAccessDescriptor.withFields(new FieldAccessDescriptor.FieldDescriptor[0]).withNestedField(fieldAccessed, fieldAccessDescriptor);
            }
            return fieldAccessDescriptor;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor visitQualifyComponent(@UnknownKeyFor @NonNull @Initialized FieldSpecifierNotationParser.QualifyComponentContext ctx) {
            return ctx.qualifiedComponent().accept(this);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor visitSimpleIdentifier(@UnknownKeyFor @NonNull @Initialized FieldSpecifierNotationParser.SimpleIdentifierContext ctx) {
            FieldAccessDescriptor.FieldDescriptor field = FieldAccessDescriptor.FieldDescriptor.builder().setFieldName(ctx.IDENTIFIER().getText()).build();
            return FieldAccessDescriptor.withFields(field);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor visitWildcard(@UnknownKeyFor @NonNull @Initialized FieldSpecifierNotationParser.WildcardContext ctx) {
            return FieldAccessDescriptor.withAllFields();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor visitQualifiedComponent(@UnknownKeyFor @NonNull @Initialized FieldSpecifierNotationParser.QualifiedComponentContext ctx) {
            QualifierVisitor qualifierVisitor = new QualifierVisitor();
            ctx.qualifierList().accept(qualifierVisitor);
            FieldAccessDescriptor.FieldDescriptor field = FieldAccessDescriptor.FieldDescriptor.builder().setFieldName(ctx.IDENTIFIER().getText()).setQualifiers(qualifierVisitor.getQualifiers()).build();
            return FieldAccessDescriptor.withFields(field);
        }
    }
}

