/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mail.metadata;

import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mail.metadata.MailServerConnection;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MailServerConnectionEditor
extends MetadataEditor<MailServerConnection> {
    private static final Class<?> PKG = MailServerConnectionEditor.class;
    private IVariables variables;
    private Text wName;
    private TextVar wServerHost;
    private TextVar wServerPort;
    private Button wUseAuthentication;
    private Button wUseXOAuth2;
    private TextVar wServerUsername;
    private PasswordTextVar wServerPassword;
    private Button wUseSecureAuthentication;
    private ComboVar wSecureConnectionType;
    private Button wUseProxy;
    private TextVar wProxyUsername;
    private PasswordTextVar wProxyPassword;
    private ComboVar wConnectionProtocol;
    private Button wCheckServerIdentity;
    private LabelTextVar wTrustedHosts;

    public MailServerConnectionEditor(HopGui hopGui, MetadataManager<MailServerConnection> manager, MailServerConnection metadata) {
        super(hopGui, manager, (IHopMetadata)metadata);
    }

    public void createControl(Composite composite) {
        Control[] controls;
        this.variables = HopGui.getInstance().getVariables();
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = PropsUi.getMargin();
        IVariables variables = this.hopGui.getVariables();
        Label wlName = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.Name", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(composite, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        Label wlConnectionProtocol = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlConnectionProtocol);
        wlConnectionProtocol.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.ConnectionProtocol", (String[])new String[0]));
        FormData fdlConnectionProtocol = new FormData();
        fdlConnectionProtocol.top = new FormAttachment((Control)lastControl, margin);
        fdlConnectionProtocol.left = new FormAttachment(0, 0);
        fdlConnectionProtocol.right = new FormAttachment(middle, -margin);
        wlConnectionProtocol.setLayoutData((Object)fdlConnectionProtocol);
        this.wConnectionProtocol = new ComboVar(variables, composite, 2052);
        PropsUi.setLook((Widget)this.wConnectionProtocol);
        FormData fdConnectionProtocol = new FormData();
        fdConnectionProtocol.top = new FormAttachment((Control)lastControl, margin);
        fdConnectionProtocol.left = new FormAttachment(middle, 0);
        fdConnectionProtocol.right = new FormAttachment(100, 0);
        this.wConnectionProtocol.setLayoutData((Object)fdConnectionProtocol);
        lastControl = this.wConnectionProtocol;
        String[] protocols = new String[]{"SMTP", "IMAP", "POP3", "MBOX"};
        this.wConnectionProtocol.setItems(protocols);
        this.wConnectionProtocol.select(1);
        Label wlServerHostLabel = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlServerHostLabel);
        wlServerHostLabel.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.ServerHost", (String[])new String[0]));
        FormData fdlServerHostLabel = new FormData();
        fdlServerHostLabel.top = new FormAttachment((Control)lastControl, margin);
        fdlServerHostLabel.left = new FormAttachment(0, 0);
        fdlServerHostLabel.right = new FormAttachment(middle, -margin);
        wlServerHostLabel.setLayoutData((Object)fdlServerHostLabel);
        this.wServerHost = new TextVar(variables, composite, 18436);
        PropsUi.setLook((Widget)this.wServerHost);
        FormData fdServerHost = new FormData();
        fdServerHost.top = new FormAttachment((Control)lastControl, margin);
        fdServerHost.left = new FormAttachment(middle, 0);
        fdServerHost.right = new FormAttachment(100, 0);
        this.wServerHost.setLayoutData((Object)fdServerHost);
        lastControl = this.wServerHost;
        Label wlServerPortLabel = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlServerPortLabel);
        wlServerPortLabel.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.ServerPort", (String[])new String[0]));
        FormData fdlServerPortLabel = new FormData();
        fdlServerPortLabel.top = new FormAttachment((Control)lastControl, margin);
        fdlServerPortLabel.left = new FormAttachment(0, 0);
        fdlServerPortLabel.right = new FormAttachment(middle, -margin);
        wlServerPortLabel.setLayoutData((Object)fdlServerPortLabel);
        this.wServerPort = new TextVar(variables, composite, 18436);
        PropsUi.setLook((Widget)this.wServerPort);
        FormData fdServerPort = new FormData();
        fdServerPort.top = new FormAttachment((Control)lastControl, margin);
        fdServerPort.left = new FormAttachment(middle, 0);
        fdServerPort.right = new FormAttachment(100, 0);
        this.wServerPort.setLayoutData((Object)fdServerPort);
        lastControl = this.wServerPort;
        Label wlUseAuthenticationLabel = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlUseAuthenticationLabel);
        wlUseAuthenticationLabel.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.UseAuthentication", (String[])new String[0]));
        FormData fdlUseAuthenticationLabel = new FormData();
        fdlUseAuthenticationLabel.top = new FormAttachment((Control)lastControl, margin);
        fdlUseAuthenticationLabel.left = new FormAttachment(0, 0);
        fdlUseAuthenticationLabel.right = new FormAttachment(middle, 0);
        wlUseAuthenticationLabel.setLayoutData((Object)fdlUseAuthenticationLabel);
        this.wUseAuthentication = new Button(composite, 16416);
        PropsUi.setLook((Widget)this.wUseAuthentication);
        FormData fdUseAuthentication = new FormData();
        fdUseAuthentication.top = new FormAttachment((Control)lastControl, margin);
        fdUseAuthentication.left = new FormAttachment(middle, 0);
        fdUseAuthentication.right = new FormAttachment(100, 0);
        this.wUseAuthentication.setLayoutData((Object)fdUseAuthentication);
        lastControl = this.wUseAuthentication;
        Label wlUseXOAuth2Label = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlUseXOAuth2Label);
        wlUseXOAuth2Label.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.UseXOAuth2", (String[])new String[0]));
        FormData fdlUseXOAuth2Label = new FormData();
        fdlUseXOAuth2Label.top = new FormAttachment((Control)lastControl, margin);
        fdlUseXOAuth2Label.left = new FormAttachment(0, 0);
        fdlUseXOAuth2Label.right = new FormAttachment(middle, -margin);
        wlUseXOAuth2Label.setLayoutData((Object)fdlUseXOAuth2Label);
        this.wUseXOAuth2 = new Button(composite, 16416);
        PropsUi.setLook((Widget)this.wUseXOAuth2);
        FormData fdUseXOAuth2 = new FormData();
        fdUseXOAuth2.top = new FormAttachment((Control)lastControl, margin);
        fdUseXOAuth2.left = new FormAttachment(middle, 0);
        fdUseXOAuth2.right = new FormAttachment(100, 0);
        this.wUseXOAuth2.setLayoutData((Object)fdUseXOAuth2);
        lastControl = this.wUseXOAuth2;
        Label wlServerUsernameLabel = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlServerUsernameLabel);
        wlServerUsernameLabel.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.Username", (String[])new String[0]));
        FormData fdlServerUsernameLabel = new FormData();
        fdlServerUsernameLabel.top = new FormAttachment((Control)lastControl, margin);
        fdlServerUsernameLabel.left = new FormAttachment(0, 0);
        fdlServerUsernameLabel.right = new FormAttachment(middle, -margin);
        wlServerUsernameLabel.setLayoutData((Object)fdlServerUsernameLabel);
        this.wServerUsername = new TextVar(variables, composite, 18436);
        PropsUi.setLook((Widget)this.wServerUsername);
        FormData fdServerUsername = new FormData();
        fdServerUsername.top = new FormAttachment((Control)lastControl, margin);
        fdServerUsername.left = new FormAttachment(middle, 0);
        fdServerUsername.right = new FormAttachment(100, 0);
        this.wServerUsername.setLayoutData((Object)fdServerUsername);
        lastControl = this.wServerUsername;
        Label wlServerPasswordLabel = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlServerPasswordLabel);
        wlServerPasswordLabel.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.Password", (String[])new String[0]));
        FormData fdlServerPasswordLabel = new FormData();
        fdlServerPasswordLabel.top = new FormAttachment((Control)lastControl, margin);
        fdlServerPasswordLabel.left = new FormAttachment(0, 0);
        fdlServerPasswordLabel.right = new FormAttachment(middle, -margin);
        wlServerPasswordLabel.setLayoutData((Object)fdlServerPasswordLabel);
        this.wServerPassword = new PasswordTextVar(variables, composite, 2052);
        PropsUi.setLook((Widget)this.wServerPassword);
        FormData fdServerPassword = new FormData();
        fdServerPassword.top = new FormAttachment((Control)lastControl, margin);
        fdServerPassword.left = new FormAttachment(middle, 0);
        fdServerPassword.right = new FormAttachment(100, 0);
        this.wServerPassword.setLayoutData((Object)fdServerPassword);
        lastControl = this.wServerPassword;
        Label wlUseSecureAuthenticationLabel = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlUseSecureAuthenticationLabel);
        wlUseSecureAuthenticationLabel.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.UseSecureAuthentication", (String[])new String[0]));
        FormData fdlUseSecureAuthenticationLabel = new FormData();
        fdlUseSecureAuthenticationLabel.top = new FormAttachment((Control)lastControl, margin);
        fdlUseSecureAuthenticationLabel.left = new FormAttachment(0, 0);
        fdlUseSecureAuthenticationLabel.right = new FormAttachment(middle, -margin);
        wlUseSecureAuthenticationLabel.setLayoutData((Object)fdlUseSecureAuthenticationLabel);
        this.wUseSecureAuthentication = new Button(composite, 16416);
        PropsUi.setLook((Widget)this.wUseSecureAuthentication);
        FormData fdUseSecureAuthentication = new FormData();
        fdUseSecureAuthentication.top = new FormAttachment((Control)lastControl, margin);
        fdUseSecureAuthentication.left = new FormAttachment(middle, 0);
        fdUseSecureAuthentication.right = new FormAttachment(100, 0);
        this.wUseSecureAuthentication.setLayoutData((Object)fdUseSecureAuthentication);
        lastControl = this.wUseSecureAuthentication;
        Label wlSecureAuthenticationTypeLabel = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlSecureAuthenticationTypeLabel);
        wlSecureAuthenticationTypeLabel.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.UseSecureAuthenticationType", (String[])new String[0]));
        FormData fdlUseSecureAuthenticationTypeLabel = new FormData();
        fdlUseSecureAuthenticationTypeLabel.top = new FormAttachment((Control)lastControl, margin);
        fdlUseSecureAuthenticationTypeLabel.left = new FormAttachment(0, 0);
        fdlUseSecureAuthenticationTypeLabel.right = new FormAttachment(middle, -margin);
        wlSecureAuthenticationTypeLabel.setLayoutData((Object)fdlUseSecureAuthenticationTypeLabel);
        this.wSecureConnectionType = new ComboVar(variables, composite, 2052);
        this.wSecureConnectionType.add("SSL");
        this.wSecureConnectionType.add("TLS");
        this.wSecureConnectionType.add("TLS 1.2");
        PropsUi.setLook((Widget)this.wSecureConnectionType);
        FormData fdSecureConnectionType = new FormData();
        fdSecureConnectionType.top = new FormAttachment((Control)lastControl, margin);
        fdSecureConnectionType.left = new FormAttachment(middle, 0);
        fdSecureConnectionType.right = new FormAttachment(100, 0);
        this.wSecureConnectionType.setLayoutData((Object)fdSecureConnectionType);
        String[] secureConnectionType = new String[]{"SSL", "TLS", "TLS 1.2"};
        lastControl = this.wSecureConnectionType;
        Label wlCheckServerIdentity = new Label(composite, 131072);
        wlCheckServerIdentity.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.CheckServerIdentity", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCheckServerIdentity);
        FormData fdlCheckServerIdentity = new FormData();
        fdlCheckServerIdentity.left = new FormAttachment(0, 0);
        fdlCheckServerIdentity.top = new FormAttachment((Control)lastControl, 0);
        fdlCheckServerIdentity.right = new FormAttachment(middle, 0);
        wlCheckServerIdentity.setLayoutData((Object)fdlCheckServerIdentity);
        this.wCheckServerIdentity = new Button(composite, 16416);
        PropsUi.setLook((Widget)this.wCheckServerIdentity);
        FormData fdCheckServerIdentity = new FormData();
        fdCheckServerIdentity.left = new FormAttachment(middle, 0);
        fdCheckServerIdentity.top = new FormAttachment((Control)lastControl, margin);
        fdCheckServerIdentity.right = new FormAttachment(100, 0);
        this.wCheckServerIdentity.setLayoutData((Object)fdCheckServerIdentity);
        this.wCheckServerIdentity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MailServerConnectionEditor.this.setChanged();
            }
        });
        lastControl = this.wCheckServerIdentity;
        this.wTrustedHosts = new LabelTextVar(variables, composite, BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.TrustedHosts", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.TrustedHosts.Tooltip", (String[])new String[0]));
        FormData fdTrustedHosts = new FormData();
        fdTrustedHosts.left = new FormAttachment(0, 0);
        fdTrustedHosts.top = new FormAttachment((Control)wlCheckServerIdentity, 0);
        fdTrustedHosts.right = new FormAttachment(100, 0);
        this.wTrustedHosts.setLayoutData((Object)fdTrustedHosts);
        lastControl = this.wTrustedHosts;
        Label wlUseProxy = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlUseProxy);
        wlUseProxy.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.UseProxy", (String[])new String[0]));
        FormData fdlUseProxy = new FormData();
        fdlUseProxy.top = new FormAttachment((Control)lastControl, margin);
        fdlUseProxy.left = new FormAttachment(0, 0);
        fdlUseProxy.right = new FormAttachment(middle, -margin);
        wlUseProxy.setLayoutData((Object)fdlUseProxy);
        this.wUseProxy = new Button(composite, 16416);
        PropsUi.setLook((Widget)this.wUseProxy);
        FormData fdUseProxy = new FormData();
        fdUseProxy.top = new FormAttachment((Control)lastControl, margin);
        fdUseProxy.left = new FormAttachment(middle, 0);
        fdUseProxy.right = new FormAttachment(100, 0);
        this.wUseProxy.setLayoutData((Object)fdUseProxy);
        lastControl = this.wUseProxy;
        Label wlProxyUsername = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlProxyUsername);
        wlProxyUsername.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.ProxyUsername", (String[])new String[0]));
        FormData fdlProxyUsername = new FormData();
        fdlProxyUsername.top = new FormAttachment((Control)lastControl, margin);
        fdlProxyUsername.left = new FormAttachment(0, 0);
        fdlProxyUsername.right = new FormAttachment(middle, -margin);
        wlProxyUsername.setLayoutData((Object)fdlProxyUsername);
        this.wProxyUsername = new TextVar(variables, composite, 2052);
        PropsUi.setLook((Widget)this.wProxyUsername);
        FormData fdProxyUsername = new FormData();
        fdProxyUsername.top = new FormAttachment((Control)lastControl, margin);
        fdProxyUsername.left = new FormAttachment(middle, 0);
        fdProxyUsername.right = new FormAttachment(100, 0);
        this.wProxyUsername.setLayoutData((Object)fdProxyUsername);
        lastControl = this.wProxyUsername;
        Label wlProxyPassword = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlProxyPassword);
        wlProxyPassword.setText(BaseMessages.getString(PKG, (String)"MailServerConnectionDialog.ProxyPassword", (String[])new String[0]));
        FormData fdlProxyPassword = new FormData();
        fdlProxyPassword.top = new FormAttachment((Control)lastControl, margin);
        fdlProxyPassword.left = new FormAttachment(0, 0);
        fdlProxyPassword.right = new FormAttachment(middle, -margin);
        wlProxyPassword.setLayoutData((Object)fdlProxyPassword);
        this.wProxyPassword = new PasswordTextVar(variables, composite, 2052);
        PropsUi.setLook((Widget)this.wProxyPassword);
        FormData fdProxyPassword = new FormData();
        fdProxyPassword.top = new FormAttachment((Control)lastControl, margin);
        fdProxyPassword.left = new FormAttachment(middle, 0);
        fdProxyPassword.right = new FormAttachment(100, 0);
        this.wProxyPassword.setLayoutData((Object)fdProxyPassword);
        lastControl = this.wProxyPassword;
        this.setWidgetsContent();
        this.resetChanged();
        for (Control control : controls = new Control[]{this.wName, this.wServerHost, this.wServerPort, this.wUseAuthentication, this.wUseXOAuth2, this.wServerUsername, this.wServerPassword, this.wUseSecureAuthentication, this.wSecureConnectionType, this.wUseProxy, this.wProxyUsername, this.wConnectionProtocol}) {
            control.addListener(24, e -> {
                this.setChanged();
                MetadataPerspective.getInstance().updateEditor((MetadataEditor)this);
            });
            control.addListener(13, e -> {
                this.setChanged();
                MetadataPerspective.getInstance().updateEditor((MetadataEditor)this);
            });
        }
    }

    public Button[] createButtonsForButtonBar(Composite composite) {
        Button wTest = new Button(composite, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        wTest.addListener(13, e -> this.testConnection());
        return new Button[]{wTest};
    }

    public void setWidgetsContent() {
        this.wName.setText(Const.NVL((String)((MailServerConnection)this.metadata).getName(), (String)""));
        this.wServerHost.setText(Const.NVL((String)((MailServerConnection)this.metadata).getServerHost(), (String)""));
        this.wServerPort.setText(Const.NVL((String)((MailServerConnection)this.metadata).getServerPort(), (String)""));
        this.wUseAuthentication.setSelection(((MailServerConnection)this.metadata).isUseAuthentication());
        this.wUseXOAuth2.setSelection(((MailServerConnection)this.metadata).isUseXOAuth2());
        this.wServerUsername.setText(Const.NVL((String)((MailServerConnection)this.metadata).getUsername(), (String)""));
        this.wServerPassword.setText(Const.NVL((String)((MailServerConnection)this.metadata).getPassword(), (String)""));
        this.wUseSecureAuthentication.setSelection(((MailServerConnection)this.metadata).isUseSecureAuthentication());
        this.wSecureConnectionType.setText(Const.NVL((String)((MailServerConnection)this.metadata).getSecureConnectionType(), (String)""));
        this.wUseProxy.setSelection(((MailServerConnection)this.metadata).isUseProxy());
        this.wTrustedHosts.setText(Const.NVL((String)((MailServerConnection)this.metadata).getTrustedHosts(), (String)""));
        this.wCheckServerIdentity.setSelection(this.wCheckServerIdentity.getSelection());
        this.wProxyUsername.setText(Const.NVL((String)((MailServerConnection)this.metadata).getProxyUsername(), (String)""));
        this.wConnectionProtocol.setText(Const.NVL((String)((MailServerConnection)this.metadata).getProtocol(), (String)""));
    }

    public void getWidgetsContent(MailServerConnection connection) {
        connection.setName(this.wName.getText());
        connection.setProtocol(Const.NVL((String)this.wConnectionProtocol.getText(), (String)""));
        connection.setServerHost(this.wServerHost.getText());
        connection.setServerPort(this.wServerPort.getText());
        connection.setUseAuthentication(this.wUseAuthentication.getSelection());
        connection.setUseXOAuth2(this.wUseXOAuth2.getSelection());
        connection.setUsername(this.wServerUsername.getText());
        connection.setPassword(this.wServerPassword.getText());
        connection.setUseSecureAuthentication(this.wUseSecureAuthentication.getSelection());
        connection.setSecureConnectionType(this.wSecureConnectionType.getText());
        connection.setTrustedHosts(this.wTrustedHosts.getText());
        connection.setCheckServerIdentity(this.wCheckServerIdentity.getSelection());
        connection.setUseProxy(this.wUseProxy.getSelection());
        connection.setProxyUsername(this.wProxyUsername.getText());
    }

    private void testConnection() {
        MailServerConnection connection = new MailServerConnection();
        connection.setName(this.wName.getText());
        connection.setProtocol(this.variables.resolve(this.wConnectionProtocol.getText()));
        connection.setServerHost(this.variables.resolve(this.wServerHost.getText()));
        connection.setServerPort(this.variables.resolve(this.wServerPort.getText()));
        connection.setUseAuthentication(this.wUseSecureAuthentication.getSelection());
        connection.setSecureConnectionType(this.wSecureConnectionType.getText());
        connection.setUseXOAuth2(this.wUseXOAuth2.getSelection());
        connection.setUsername(this.variables.resolve(this.wServerUsername.getText()));
        connection.setPassword(this.variables.resolve(this.wServerPassword.getText()));
        connection.setUseSecureAuthentication(this.wUseSecureAuthentication.getSelection());
        connection.setUseProxy(this.wUseProxy.getSelection());
        connection.setProxyUsername(this.variables.resolve(this.wProxyUsername.getText()));
        try {
            if (connection.testConnection(connection.getSession(this.variables))) {
                MessageBox mb = new MessageBox(this.hopGui.getShell(), 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"ActionGetPOP.Connected.OK", (String[])new String[]{this.variables.resolve(this.wServerHost.getText())}) + Const.CR);
                mb.setText(BaseMessages.getString(PKG, (String)"ActionGetPOP.Connected.Title.Ok", (String[])new String[0]));
                mb.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), "Error", "Error connecting mail server:", e);
        }
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }

    public void dispose() {
    }
}

