/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.util.CloseableIterator;

final class NonSpanningWrapper
implements DataInputView {
    private static final String BROKEN_SERIALIZATION_ERROR_MESSAGE = "Serializer consumed more bytes than the record had. This indicates broken serialization. If you are using custom serialization types (Value or Writable), check their serialization methods. If you are using a Kryo-serialized type, check the corresponding Kryo serializer.";
    private MemorySegment segment;
    private int limit;
    private int position;
    private byte[] utfByteBuffer;
    private char[] utfCharBuffer;

    NonSpanningWrapper() {
    }

    private int remaining() {
        return this.limit - this.position;
    }

    void clear() {
        this.segment = null;
        this.limit = 0;
        this.position = 0;
    }

    void initializeFromMemorySegment(MemorySegment seg, int position, int limit) {
        this.segment = seg;
        this.position = position;
        this.limit = limit;
    }

    CloseableIterator<Buffer> getUnconsumedSegment() {
        if (!this.hasRemaining()) {
            return CloseableIterator.empty();
        }
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)this.remaining());
        this.segment.copyTo(this.position, segment, 0, this.remaining());
        return NonSpanningWrapper.singleBufferIterator(segment);
    }

    boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public final void readFully(byte[] b) {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.segment.get(this.position, b, off, len);
        this.position += len;
    }

    public final boolean readBoolean() {
        return this.readByte() == 1;
    }

    public final byte readByte() {
        return this.segment.get(this.position++);
    }

    public final int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    public final short readShort() {
        short v = this.segment.getShortBigEndian(this.position);
        this.position += 2;
        return v;
    }

    public final int readUnsignedShort() {
        int v = this.segment.getShortBigEndian(this.position) & 0xFFFF;
        this.position += 2;
        return v;
    }

    public final char readChar() {
        char v = this.segment.getCharBigEndian(this.position);
        this.position += 2;
        return v;
    }

    public final int readInt() {
        int v = this.segment.getIntBigEndian(this.position);
        this.position += 4;
        return v;
    }

    public final long readLong() {
        long v = this.segment.getLongBigEndian(this.position);
        this.position += 8;
        return v;
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() {
        int b;
        StringBuilder bld = new StringBuilder(32);
        while ((b = this.readUnsignedByte()) != 10) {
            if (b == 13) continue;
            bld.append((char)b);
        }
        if (bld.length() == 0) {
            return null;
        }
        int len = bld.length();
        if (len > 0 && bld.charAt(len - 1) == '\r') {
            bld.setLength(len - 1);
        }
        return bld.toString();
    }

    public final String readUTF() throws UTFDataFormatException {
        int c;
        int count;
        char[] chararr;
        byte[] bytearr;
        int utflen = this.readUnsignedShort();
        if (this.utfByteBuffer == null || this.utfByteBuffer.length < utflen) {
            bytearr = new byte[utflen];
            this.utfByteBuffer = bytearr;
        } else {
            bytearr = this.utfByteBuffer;
        }
        if (this.utfCharBuffer == null || this.utfCharBuffer.length < utflen) {
            chararr = new char[utflen];
            this.utfCharBuffer = chararr;
        } else {
            chararr = this.utfCharBuffer;
        }
        int chararrCount = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararrCount++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararrCount++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararrCount);
    }

    public final int skipBytes(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int toSkip = Math.min(n, this.remaining());
        this.position += toSkip;
        return toSkip;
    }

    public void skipBytesToRead(int numBytes) throws EOFException {
        int skippedBytes = this.skipBytes(numBytes);
        if (skippedBytes < numBytes) {
            throw new EOFException("Could not skip " + numBytes + " bytes.");
        }
    }

    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("Byte array b cannot be null.");
        }
        if (off < 0) {
            throw new IllegalArgumentException("The offset off cannot be negative.");
        }
        if (len < 0) {
            throw new IllegalArgumentException("The length len cannot be negative.");
        }
        int toRead = Math.min(len, this.remaining());
        this.segment.get(this.position, b, off, toRead);
        this.position += toRead;
        return toRead;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    ByteBuffer wrapIntoByteBuffer() {
        return this.segment.wrap(this.position, this.remaining());
    }

    int copyContentTo(byte[] dst) {
        int numBytesChunk = this.remaining();
        this.segment.get(this.position, dst, 0, numBytesChunk);
        return numBytesChunk;
    }

    void transferTo(ByteBuffer dst) {
        this.segment.get(this.position, dst, this.remaining());
        this.clear();
    }

    RecordDeserializer.DeserializationResult readInto(IOReadableWritable target) throws IOException {
        try {
            target.read((DataInputView)this);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(BROKEN_SERIALIZATION_ERROR_MESSAGE, e);
        }
        int remaining = this.remaining();
        if (remaining < 0) {
            throw new IOException(BROKEN_SERIALIZATION_ERROR_MESSAGE, new IndexOutOfBoundsException("Remaining = " + remaining));
        }
        return remaining == 0 ? RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER : RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
    }

    boolean hasCompleteLength() {
        return this.remaining() >= 4;
    }

    boolean canReadRecord(int recordLength) {
        return recordLength <= this.remaining();
    }

    static CloseableIterator<Buffer> singleBufferIterator(MemorySegment target) {
        return CloseableIterator.ofElement((Object)new NetworkBuffer(target, FreeingBufferRecycler.INSTANCE, Buffer.DataType.DATA_BUFFER, target.size()), Buffer::recycleBuffer);
    }
}

