/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionPool;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.ConnectionPoolEvent;
import com.ibm.as400.access.JDTrace;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

class PoolConnectionEventListener
implements ConnectionEventListener {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private transient AS400JDBCConnectionPool pool_;

    public PoolConnectionEventListener(AS400JDBCConnectionPool pool) {
        this.pool_ = pool;
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        JDTrace.logInformation(this, "PooledConnection is in error...");
        this.pool_.closePooledConnection((AS400JDBCPooledConnection)event.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ConnectionEvent event) {
        block19: {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "connectionClosed()");
            }
            AS400JDBCPooledConnection connection = (AS400JDBCPooledConnection)event.getSource();
            Vector vector = this.pool_.activePool_;
            synchronized (vector) {
                this.pool_.activePool_.removeElement(connection);
            }
            if (this.pool_.getMaxLifetime() != -1L && connection.getLifeSpan() > this.pool_.getMaxLifetime() || this.pool_.getMaxUseCount() != -1 && connection.getUseCount() == this.pool_.getMaxUseCount() || this.pool_.getMaxConnections() != -1 && this.pool_.activePool_.size() > this.pool_.getMaxConnections()) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "connectionClosed() Connection has expired.  Removed from the pool.");
                }
                this.pool_.closePooledConnection(connection);
                if (this.pool_.poolListeners_ != null) {
                    ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(connection, 4);
                    this.pool_.poolListeners_.fireConnectionExpiredEvent(poolEvent);
                }
            } else {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "connectionClosed() Returning active connection to the pool.");
                }
                AS400JDBCConnection jdbcConnection = connection.getInternalConnection();
                try {
                    if (!jdbcConnection.isClosed()) {
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "connectionClosed() adding to avaialblePool_");
                        }
                        Vector vector2 = this.pool_.availablePool_;
                        synchronized (vector2) {
                            this.pool_.availablePool_.addElement(connection);
                        }
                        if (this.pool_.poolListeners_ != null) {
                            ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(connection, 3);
                            this.pool_.poolListeners_.fireConnectionReturnedEvent(poolEvent);
                        }
                        break block19;
                    }
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "connectionClosed() Removing closed connection from pool.");
                    }
                }
                catch (SQLException sqe) {
                    if (!JDTrace.isTraceOn()) break block19;
                    JDTrace.logException(this, "connectionClosed() exception caught", sqe);
                }
            }
        }
        if (!this.pool_.isThreadUsed() && this.pool_.isRunMaintenance() && System.currentTimeMillis() - this.pool_.lastSingleThreadRun_ > this.pool_.getCleanupInterval()) {
            this.pool_.cleanupConnections();
        }
    }
}

