/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.binary.BinaryIdMapper;
import org.apache.ignite.binary.BinaryNameMapper;
import org.apache.ignite.binary.BinarySerializer;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;

public class BinaryConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final boolean DFLT_COMPACT_FOOTER = true;
    private BinaryIdMapper idMapper;
    private BinaryNameMapper nameMapper;
    private BinarySerializer serializer;
    private Collection<BinaryTypeConfiguration> typeCfgs;
    private boolean compactFooter = true;

    public BinaryConfiguration setClassNames(Collection<String> clsNames) {
        if (this.typeCfgs == null) {
            this.typeCfgs = new ArrayList<BinaryTypeConfiguration>(clsNames.size());
        }
        for (String clsName : clsNames) {
            this.typeCfgs.add(new BinaryTypeConfiguration(clsName));
        }
        return this;
    }

    public BinaryIdMapper getIdMapper() {
        return this.idMapper;
    }

    public BinaryConfiguration setIdMapper(BinaryIdMapper idMapper) {
        this.idMapper = idMapper;
        return this;
    }

    public BinaryNameMapper getNameMapper() {
        return this.nameMapper;
    }

    public BinaryConfiguration setNameMapper(BinaryNameMapper nameMapper) {
        this.nameMapper = nameMapper;
        return this;
    }

    public BinarySerializer getSerializer() {
        return this.serializer;
    }

    public BinaryConfiguration setSerializer(BinarySerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public Collection<BinaryTypeConfiguration> getTypeConfigurations() {
        return this.typeCfgs;
    }

    public BinaryConfiguration setTypeConfigurations(Collection<BinaryTypeConfiguration> typeCfgs) {
        this.typeCfgs = typeCfgs;
        return this;
    }

    public boolean isCompactFooter() {
        return this.compactFooter;
    }

    public BinaryConfiguration setCompactFooter(boolean compactFooter) {
        this.compactFooter = compactFooter;
        return this;
    }

    public String toString() {
        return S.toString(BinaryConfiguration.class, this);
    }
}

