/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public final class IOVersions<V extends PageIO> {
    private final V[] vers;
    private final int type;
    private final V latest;

    @SafeVarargs
    public IOVersions(V ... vers) {
        assert (vers != null);
        assert (vers.length > 0);
        this.vers = vers;
        this.type = ((PageIO)vers[0]).getType();
        this.latest = vers[vers.length - 1];
        assert (this.checkVersions());
    }

    public int getType() {
        return this.type;
    }

    private boolean checkVersions() {
        for (int i = 0; i < this.vers.length; ++i) {
            V v = this.vers[i];
            if (((PageIO)v).getType() == this.type && ((PageIO)v).getVersion() == i + 1) continue;
            return false;
        }
        return true;
    }

    public V latest() {
        return this.latest;
    }

    public V forVersion(int ver) {
        if (ver == 0) {
            throw new IllegalStateException("Failed to get page IO instance (page content is corrupted)");
        }
        return this.vers[ver - 1];
    }

    public V forPage(long pageAddr) {
        int ver = PageIO.getVersion(pageAddr);
        V res = this.forVersion(ver);
        assert (((PageIO)res).getType() == PageIO.getType(pageAddr)) : "resType=" + ((PageIO)res).getType() + ", pageType=" + PageIO.getType(pageAddr);
        return res;
    }

    public String toString() {
        return S.toString(IOVersions.class, this);
    }
}

