/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsProcessor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.query.running.HeavyQueriesTracker;
import org.apache.ignite.internal.processors.query.running.TrackableQuery;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcResultSet;
import org.h2.result.ResultInterface;
import org.h2.value.Value;

public abstract class H2ResultSetIterator<T>
extends GridIteratorAdapter<T>
implements GridCloseableIterator<T> {
    private static final Field RESULT_FIELD;
    private static final long serialVersionUID = 0L;
    private ResultInterface res;
    private ResultSet data;
    protected Object[] row;
    private List<Object[]> page;
    private boolean hasRow;
    private final int pageSize;
    private final int colCnt;
    private Iterator<Object[]> rowIter;
    private final Session ses;
    private boolean closed;
    private boolean canceled;
    final HeavyQueriesTracker.ResultSetChecker resultSetChecker;
    protected final Tracing tracing;
    private final GridKernalContext ctx;
    private final H2QueryInfo qryInfo;
    final IgniteH2Indexing h2;

    protected H2ResultSetIterator(ResultSet data, int pageSize, IgniteLogger log, IgniteH2Indexing h2, H2QueryInfo qryInfo, Tracing tracing) throws IgniteCheckedException {
        this.ctx = h2.ctx;
        this.pageSize = pageSize;
        this.data = data;
        this.tracing = tracing;
        this.qryInfo = qryInfo;
        this.h2 = h2;
        try {
            this.res = (ResultInterface)RESULT_FIELD.get(data);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        if (data != null) {
            try {
                this.colCnt = data.getMetaData().getColumnCount();
                this.ses = H2Utils.session(data.getStatement().getConnection());
                this.page = new ArrayList<Object[]>(pageSize);
            }
            catch (SQLException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        } else {
            this.colCnt = 0;
            this.page = null;
            this.row = null;
            this.ses = null;
        }
        assert (log != null);
        assert (h2 != null);
        assert (qryInfo != null);
        this.resultSetChecker = h2.heavyQueriesTracker().resultSetChecker((TrackableQuery)qryInfo);
    }

    /*
     * Loose catch block
     */
    private boolean fetchPage() throws IgniteCheckedException {
        this.lockTables();
        try {
            boolean bl;
            block25: {
                MTC.TraceSurroundings ignored;
                block23: {
                    block24: {
                        block26: {
                            block21: {
                                boolean bl2;
                                block22: {
                                    ignored = MTC.support((Span)this.tracing.create(SpanType.SQL_PAGE_FETCH, MTC.span()));
                                    GridH2Table.checkTablesVersions(this.ses);
                                    this.page.clear();
                                    if (!this.data.isClosed()) break block21;
                                    bl2 = false;
                                    if (ignored == null) break block22;
                                    ignored.close();
                                }
                                return bl2;
                            }
                            break block26;
                            {
                                catch (SQLException e) {
                                    if (e.getErrorCode() == 57014) {
                                        throw new QueryCancelledException();
                                    }
                                    throw new IgniteSQLException(e);
                                }
                            }
                        }
                        for (int i = 0; i < this.pageSize; ++i) {
                            try {
                                if (!this.data.next()) break;
                                this.row = new Object[this.colCnt];
                                this.readRow();
                                this.page.add(this.row);
                                continue;
                            }
                            catch (SQLException e) {
                                this.close();
                                if (e.getCause() instanceof IgniteSQLException) {
                                    throw (IgniteSQLException)e.getCause();
                                }
                                if (e.getErrorCode() == 57014) {
                                    throw new QueryCancelledException();
                                }
                                throw new IgniteSQLException(e);
                            }
                        }
                        MTC.span().addTag("sql.page.rows", () -> Integer.toString(this.page.size()));
                        if (!F.isEmpty(this.page)) break block23;
                        this.rowIter = null;
                        bl = false;
                        if (ignored == null) break block24;
                        ignored.close();
                    }
                    return bl;
                }
                try {
                    this.rowIter = this.page.iterator();
                    bl = true;
                    if (ignored == null) break block25;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return bl;
        }
        finally {
            this.unlockTables();
        }
    }

    private void readRow() throws SQLException {
        if (this.res != null) {
            Value[] values = this.res.currentRow();
            for (int c = 0; c < this.row.length; ++c) {
                Value val = values[c];
                if (val instanceof GridH2ValueCacheObject) {
                    GridH2ValueCacheObject valCacheObj = (GridH2ValueCacheObject)values[c];
                    this.row[c] = valCacheObj.getObject(true);
                    continue;
                }
                this.row[c] = val.getObject();
            }
        } else {
            for (int c = 0; c < this.row.length; ++c) {
                this.row[c] = this.data.getObject(c + 1);
            }
        }
    }

    public void lockTables() {
        if (!this.isClosed() && this.ses.isLazyQueryExecution()) {
            GridH2Table.readLockTables(this.ses);
        }
    }

    public void unlockTables() {
        if (this.ses.isLazyQueryExecution()) {
            GridH2Table.unlockTables(this.ses);
        }
    }

    private synchronized boolean fetchNext() throws IgniteCheckedException {
        if (this.canceled) {
            throw new QueryCancelledException();
        }
        if (this.rowIter != null && this.rowIter.hasNext()) {
            this.row = this.rowIter.next();
            this.resultSetChecker.checkOnFetchNext();
            return true;
        }
        if (!this.fetchPage()) {
            this.closeInternal();
            return false;
        }
        if (this.rowIter != null && this.rowIter.hasNext()) {
            this.row = this.rowIter.next();
            this.resultSetChecker.checkOnFetchNext();
            return true;
        }
        return false;
    }

    protected abstract T createRow();

    public void onClose() throws IgniteCheckedException {
        if (this.data == null) {
            return;
        }
        this.lockTables();
        if (this.qryInfo != null) {
            this.h2.heavyQueriesTracker().stopTracking((TrackableQuery)this.qryInfo, null);
        }
        try {
            this.resultSetChecker.checkOnClose();
            PerformanceStatisticsProcessor perfStat = this.ctx.performanceStatistics();
            if (perfStat.enabled() && this.resultSetChecker.fetchedSize() > 0L) {
                perfStat.queryRowsProcessed(GridCacheQueryType.SQL_FIELDS, this.qryInfo.nodeId(), this.qryInfo.queryId(), "Fetched on reducer", this.resultSetChecker.fetchedSize());
            }
            this.data.close();
        }
        catch (SQLException e) {
            throw new IgniteSQLException(e);
        }
        finally {
            this.res = null;
            this.data = null;
            this.page = null;
            this.unlockTables();
        }
    }

    public synchronized void close() throws IgniteCheckedException {
        if (this.closed) {
            return;
        }
        this.canceled = true;
        this.closeInternal();
    }

    private synchronized void closeInternal() throws IgniteCheckedException {
        if (this.closed) {
            return;
        }
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.tracing.create(SpanType.SQL_ITER_CLOSE, MTC.span()));){
            this.closed = true;
            this.onClose();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean hasNextX() throws IgniteCheckedException {
        if (this.canceled) {
            throw new QueryCancelledException();
        }
        if (this.closed) {
            return false;
        }
        return this.hasRow || (this.hasRow = ((Boolean)this.h2.executeWithResumableTimeTracking(this::fetchNext, this.qryInfo)).booleanValue());
    }

    public T nextX() throws IgniteCheckedException {
        if (!this.hasNextX()) {
            throw new NoSuchElementException();
        }
        this.hasRow = false;
        return this.createRow();
    }

    public void removeX() throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(H2ResultSetIterator.class, (Object)((Object)this));
    }

    static {
        try {
            RESULT_FIELD = JdbcResultSet.class.getDeclaredField("result");
            RESULT_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }
}

