/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.Objects;
import org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite.internal.catalog.sql.Name;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.sql.IgniteSql;

class DropTableImpl
extends AbstractCatalogQuery<Name> {
    private Name tableName;
    private boolean ifExists;

    DropTableImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected Name result() {
        return this.tableName;
    }

    DropTableImpl name(String ... names) {
        Objects.requireNonNull(names, "Table name must not be null");
        this.tableName = new Name(names);
        return this;
    }

    DropTableImpl ifExists() {
        this.ifExists = true;
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        ctx.sql("DROP TABLE ");
        if (this.ifExists) {
            ctx.sql("IF EXISTS ");
        }
        ctx.visit(this.tableName);
        ctx.sql(";");
    }
}

