/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import java.time.ZoneId;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.InternalTxOptions;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.CancelHandle;
import org.apache.ignite.lang.CancellationToken;
import org.jetbrains.annotations.Nullable;

class JdbcConnectionContext {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Object mux = new Object();
    private final TxManager txManager;
    private final ZoneId timeZoneId;
    private final String userName;
    private final ConcurrentMap<Long, CancelHandle> cancelHandles = new ConcurrentHashMap<Long, CancelHandle>();
    @Nullable
    private TxWithTimeTracker txWithTimeTracker;

    JdbcConnectionContext(TxManager txManager, ZoneId timeZoneId, String userName) {
        this.txManager = txManager;
        this.timeZoneId = timeZoneId;
        this.userName = userName;
    }

    ZoneId timeZoneId() {
        return this.timeZoneId;
    }

    String userName() {
        return this.userName;
    }

    InternalTransaction getOrStartTransaction(HybridTimestampTracker timestampTracker) {
        if (this.txWithTimeTracker == null) {
            InternalTransaction tx = this.txManager.beginExplicitRw(timestampTracker, InternalTxOptions.defaults());
            this.txWithTimeTracker = new TxWithTimeTracker(tx, timestampTracker);
        }
        return this.txWithTimeTracker.transaction();
    }

    CompletableFuture<@Nullable HybridTimestamp> finishTransactionAsync(boolean commit) {
        TxWithTimeTracker txWithTimeTracker0 = this.txWithTimeTracker;
        this.txWithTimeTracker = null;
        if (txWithTimeTracker0 == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return commit ? txWithTimeTracker0.transaction().commitAsync().thenApply(ignore -> txWithTimeTracker0.observableTimestamp()) : txWithTimeTracker0.transaction().rollbackAsync().thenApply(ignore -> null);
    }

    boolean valid() {
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            this.finishTransactionAsync(false);
        }
    }

    CancellationToken registerExecution(long token) {
        CancelHandle handle = CancelHandle.create();
        CancelHandle previousHandle = this.cancelHandles.putIfAbsent(token, handle);
        assert (previousHandle == null);
        return handle.token();
    }

    void deregisterExecution(long token) {
        this.cancelHandles.remove(token);
    }

    CompletableFuture<Void> cancelExecution(long token) {
        CancelHandle handle = (CancelHandle)this.cancelHandles.remove(token);
        if (handle == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return handle.cancelAsync();
    }

    private static class TxWithTimeTracker {
        private final InternalTransaction transaction;
        private final HybridTimestampTracker tracker;

        private TxWithTimeTracker(InternalTransaction transaction, HybridTimestampTracker tracker) {
            this.transaction = transaction;
            this.tracker = tracker;
        }

        InternalTransaction transaction() {
            return this.transaction;
        }

        @Nullable
        HybridTimestamp observableTimestamp() {
            return this.tracker.get();
        }
    }
}

