/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.messages;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.discovery.tcp.internal.DiscoveryDataPacket;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractTraceableMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryEnsureDelivery;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryRedirectToClient;
import org.jetbrains.annotations.Nullable;

@TcpDiscoveryEnsureDelivery
@TcpDiscoveryRedirectToClient
public class TcpDiscoveryNodeAddedMessage
extends TcpDiscoveryAbstractTraceableMessage {
    private static final long serialVersionUID = 0L;
    private final TcpDiscoveryNode node;
    private DiscoveryDataPacket dataPacket;
    private Collection<TcpDiscoveryAbstractMessage> msgs;
    private IgniteUuid discardMsgId;
    private IgniteUuid discardCustomMsgId;
    @GridToStringInclude
    private Collection<TcpDiscoveryNode> top;
    @GridToStringInclude
    private transient Collection<TcpDiscoveryNode> clientTop;
    private Map<Long, Collection<ClusterNode>> topHist;
    private final long gridStartTime;

    public TcpDiscoveryNodeAddedMessage(UUID creatorNodeId, TcpDiscoveryNode node, DiscoveryDataPacket dataPacket, long gridStartTime) {
        super(creatorNodeId);
        assert (node != null);
        assert (gridStartTime > 0L);
        this.node = node;
        this.dataPacket = dataPacket;
        this.gridStartTime = gridStartTime;
    }

    public TcpDiscoveryNodeAddedMessage(TcpDiscoveryNodeAddedMessage msg) {
        super(msg);
        this.node = msg.node;
        this.msgs = msg.msgs;
        this.discardMsgId = msg.discardMsgId;
        this.discardCustomMsgId = msg.discardCustomMsgId;
        this.top = msg.top;
        this.clientTop = msg.clientTop;
        this.topHist = msg.topHist;
        this.dataPacket = msg.dataPacket;
        this.gridStartTime = msg.gridStartTime;
    }

    public TcpDiscoveryNode node() {
        return this.node;
    }

    @Nullable
    public Collection<TcpDiscoveryAbstractMessage> messages() {
        return this.msgs;
    }

    @Nullable
    public IgniteUuid discardedMessageId() {
        return this.discardMsgId;
    }

    @Nullable
    public IgniteUuid discardedCustomMessageId() {
        return this.discardCustomMsgId;
    }

    public void messages(@Nullable Collection<TcpDiscoveryAbstractMessage> msgs, @Nullable IgniteUuid discardMsgId, @Nullable IgniteUuid discardCustomMsgId) {
        this.msgs = msgs;
        this.discardMsgId = discardMsgId;
        this.discardCustomMsgId = discardCustomMsgId;
    }

    @Nullable
    public Collection<TcpDiscoveryNode> topology() {
        return this.top;
    }

    public void topology(@Nullable Collection<TcpDiscoveryNode> top) {
        this.top = top;
    }

    public void clientTopology(Collection<TcpDiscoveryNode> top) {
        assert (top != null && !top.isEmpty()) : top;
        this.clientTop = top;
    }

    public Collection<TcpDiscoveryNode> clientTopology() {
        return this.clientTop;
    }

    public Map<Long, Collection<ClusterNode>> topologyHistory() {
        return this.topHist;
    }

    public void topologyHistory(@Nullable Map<Long, Collection<ClusterNode>> topHist) {
        this.topHist = topHist;
    }

    public DiscoveryDataPacket gridDiscoveryData() {
        return this.dataPacket;
    }

    public void clearDiscoveryData() {
        this.dataPacket = null;
    }

    public void clearUnmarshalledDiscoveryData() {
        if (this.dataPacket != null) {
            this.dataPacket.clearUnmarshalledJoiningNodeData();
        }
    }

    public long gridStartTime() {
        return this.gridStartTime;
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoveryNodeAddedMessage.class, this, "super", (Object)super.toString());
    }
}

