/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.style.component;

import java.util.UUID;
import org.apache.ignite3.internal.cli.core.style.AnsiStringSupport;
import org.apache.ignite3.internal.cli.core.style.component.UiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.apache.ignite3.internal.cli.core.style.element.UiString;
import org.apache.ignite3.internal.cli.logger.CliLoggers;

public class ErrorUiComponent
implements UiComponent {
    private final String header;
    private final UiElement[] headerUiElements;
    private final String details;
    private final UiElement[] detailsUiElements;
    private final String verbose;
    private final UiElement[] verboseUiElements;
    private final UUID traceId;
    private final String errorCode;

    private ErrorUiComponent(String header, UiElement[] headerUiElements, String details, UiElement[] detailsUiElements, String verbose, UiElement[] verboseUiElements, UUID traceId, String errorCode) {
        this.header = header;
        this.headerUiElements = headerUiElements;
        this.details = details;
        this.detailsUiElements = detailsUiElements;
        this.verbose = verbose;
        this.verboseUiElements = verboseUiElements;
        this.traceId = traceId;
        this.errorCode = errorCode;
    }

    public static ErrorUiComponent fromHeader(String header) {
        return ErrorUiComponent.builder().header(header, new UiElement[0]).build();
    }

    public static ErrorComponentBuilder builder() {
        return new ErrorComponentBuilder();
    }

    public String header() {
        return this.header;
    }

    public String details() {
        return this.details;
    }

    @Override
    public String render() {
        return AnsiStringSupport.ansi(this.renderErrorCode() + this.renderTrace() + this.renderHeader() + this.renderDetails() + this.renderVerbose());
    }

    private String renderErrorCode() {
        return this.errorCode == null ? "" : AnsiStringSupport.fg(AnsiStringSupport.Color.GRAY).mark(this.errorCode);
    }

    private String renderTrace() {
        return this.traceId == null ? "" : AnsiStringSupport.fg(AnsiStringSupport.Color.GRAY).mark(" Trace ID: " + this.traceId + System.lineSeparator());
    }

    private String renderHeader() {
        return this.header == null ? "" : AnsiStringSupport.fg(AnsiStringSupport.Color.RED).with(AnsiStringSupport.Style.BOLD).mark(AnsiStringSupport.ansi(UiString.format(this.header, this.headerUiElements)));
    }

    private String renderDetails() {
        return this.details == null ? "" : System.lineSeparator() + UiString.format(this.details, this.detailsUiElements);
    }

    private String renderVerbose() {
        return this.verbose == null || !CliLoggers.isVerbose() ? "" : System.lineSeparator() + UiString.format(this.verbose, this.verboseUiElements);
    }

    public static class ErrorComponentBuilder {
        private String header;
        private UiElement[] headerUiElements;
        private String details;
        private UiElement[] detailsUiElements;
        private String verbose;
        private UiElement[] verboseUiElements;
        private UUID traceId;
        private String errorCode;

        public ErrorComponentBuilder header(String header, UiElement ... uiElements) {
            this.header = header;
            this.headerUiElements = uiElements;
            return this;
        }

        public ErrorComponentBuilder details(String details, UiElement ... uiElements) {
            this.details = details;
            this.detailsUiElements = uiElements;
            return this;
        }

        public ErrorComponentBuilder details(UiElement ... uiElements) {
            return this.details("%s", uiElements);
        }

        public ErrorComponentBuilder verbose(String verbose, UiElement ... uiElements) {
            this.verbose = verbose;
            this.verboseUiElements = uiElements;
            return this;
        }

        public ErrorComponentBuilder traceId(UUID traceId) {
            this.traceId = traceId;
            return this;
        }

        public ErrorComponentBuilder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public ErrorUiComponent build() {
            return new ErrorUiComponent(this.header, this.headerUiElements, this.details, this.detailsUiElements, this.verbose, this.verboseUiElements, this.traceId, this.errorCode);
        }
    }
}

