/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metrics.LongGauge;
import org.apache.ignite3.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite3.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite3.internal.pagememory.persistence.store.GroupPageStoresMap;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryStorageMetricSource;

class PersistentPageMemoryStorageMetrics {
    private static final IgniteLogger LOG = Loggers.forClass(PersistentPageMemoryStorageMetrics.class);

    PersistentPageMemoryStorageMetrics() {
    }

    static void initMetrics(PersistentPageMemoryStorageMetricSource source, FilePageStoreManager filePageStoreManager) {
        source.addMetric(new LongGauge("StorageSize", "Size of the entire storage in bytes.", () -> PersistentPageMemoryStorageMetrics.storageSize(filePageStoreManager)));
    }

    private static long storageSize(FilePageStoreManager filePageStoreManager) {
        return filePageStoreManager.allPageStores().mapToLong(PersistentPageMemoryStorageMetrics::fullSize).sum();
    }

    private static long fullSize(GroupPageStoresMap.GroupPartitionPageStore<FilePageStore> pageStore) {
        try {
            return pageStore.pageStore().fullSize();
        }
        catch (IgniteInternalCheckedException e) {
            LOG.warn("Error getting storage size: [groupPartitionId={}]", e, pageStore.groupPartitionId());
            return 0L;
        }
    }
}

