var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import WorkflowListTable from "../WorkflowListTable/WorkflowListTable";
import WorkflowListToolbar from "../WorkflowListToolbar/WorkflowListToolbar";
import { LoadMore } from "@kie-tools/runtime-tools-components/dist/components/LoadMore";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import _ from "lodash";
import { alterOrderByObj, workflowListDefaultStatusFilter } from "../utils/WorkflowListUtils";
import "../styles.css";
import { OrderBy } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const WorkflowList = ({ driver, isEnvelopeConnectedToChannel, initialState, ouiaId, ouiaSafe, }) => {
    const defaultStatusFilter = workflowListDefaultStatusFilter;
    const defaultFilters = initialState && initialState.filters
        ? Object.assign({}, initialState.filters) : {
        status: defaultStatusFilter,
        businessKey: [],
    };
    const defaultOrderBy = initialState && initialState.sortBy
        ? initialState.sortBy
        : {
            lastUpdate: OrderBy.DESC,
        };
    const [defaultPageSize] = useState(10);
    const [isLoading, setIsLoading] = useState(false);
    const [isLoadingMore, setIsLoadingMore] = useState(false);
    const [offset, setOffset] = useState(0);
    const [limit, setLimit] = useState(defaultPageSize);
    const [pageSize, setPageSize] = useState(defaultPageSize);
    const [workflowInstances, setWorkflowInstances] = useState([]);
    const [error, setError] = useState(undefined);
    const [filters, setFilters] = useState(defaultFilters);
    const [workflowStates, setWorkflowStates] = useState(defaultStatusFilter);
    const [expanded, setExpanded] = React.useState({});
    const [sortBy, setSortBy] = useState(defaultOrderBy);
    const [selectedInstances, setSelectedInstances] = useState([]);
    const [selectableInstances, setSelectableInstances] = useState(0);
    const [isAllChecked, setIsAllChecked] = useState(false);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            initLoad();
        }
    }, [isEnvelopeConnectedToChannel]);
    useEffect(() => {
        setIsLoading(true);
        if (initialState && initialState.filters) {
            setFilters(initialState.filters);
            setWorkflowStates(initialState.filters.status);
            setSortBy(initialState.sortBy);
        }
    }, [initialState]);
    const initLoad = () => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        setFilters(defaultFilters);
        yield driver.initialLoad(defaultFilters, defaultOrderBy);
        doQuery(0, 10, true);
    });
    const countExpandableRows = (instances) => {
        instances.forEach((workflowInstance, index) => {
            var _a;
            expanded[index] = false;
            workflowInstance.isSelected = false;
            workflowInstance.isOpen = false;
            workflowInstance.childWorkflowInstances = [];
            if (workflowInstance.serviceUrl && ((_a = workflowInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management"))) {
                setSelectableInstances((prev) => prev + 1);
            }
        });
    };
    const doQuery = (_offset, _limit, _resetWorkflows, _resetPagination = false, _loadMore = false) => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoadingMore(_loadMore);
        setSelectableInstances(0);
        setSelectedInstances([]);
        try {
            const response = yield driver.query(_offset, _limit);
            setLimit(response.length);
            if (_resetWorkflows) {
                countExpandableRows(response);
                setWorkflowInstances(response);
            }
            else {
                const newData = workflowInstances.concat(response);
                countExpandableRows(newData);
                setWorkflowInstances(newData);
            }
            if (_resetPagination) {
                setOffset(_offset);
            }
        }
        catch (err) {
            setError(err.errorMessage);
        }
        finally {
            setIsLoading(false);
            setIsLoadingMore(false);
        }
    });
    useEffect(() => {
        if (selectedInstances.length === selectableInstances && selectableInstances !== 0) {
            setIsAllChecked(true);
        }
        else {
            setIsAllChecked(false);
        }
    }, [workflowInstances]);
    const applyFilter = (filter) => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        setWorkflowInstances([]);
        yield driver.applyFilter(filter);
        doQuery(0, defaultPageSize, true, true);
    });
    const applySorting = (event, index, direction) => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        setWorkflowInstances([]);
        setSortBy({ index, direction });
        let sortingColumn = event.target.innerText;
        sortingColumn = _.camelCase(sortingColumn);
        let sortByObj = _.set({}, sortingColumn, direction.toUpperCase());
        sortByObj = alterOrderByObj(sortByObj);
        yield driver.applySorting(sortByObj);
        doQuery(0, defaultPageSize, true, true);
    });
    const doRefresh = () => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        setWorkflowInstances([]);
        doQuery(0, defaultPageSize, true, true);
    });
    const doResetFilters = () => {
        const resetFilter = {
            status: defaultStatusFilter,
            businessKey: [],
        };
        setIsLoading(true);
        setWorkflowStates(defaultStatusFilter);
        setFilters(resetFilter);
        applyFilter(resetFilter);
    };
    const mustShowLoadMore = (!isLoading || isLoadingMore) && workflowInstances && limit === pageSize && filters.status.length > 0;
    if (error) {
        return React.createElement(ServerErrors, { error: error, variant: "large" });
    }
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "workflow-list", ouiaSafe ? ouiaSafe : !isLoading)),
        React.createElement(WorkflowListToolbar, { applyFilter: applyFilter, refresh: doRefresh, filters: filters, setFilters: setFilters, workflowStates: workflowStates, setWorkflowStates: setWorkflowStates, selectedInstances: selectedInstances, setSelectedInstances: setSelectedInstances, workflowInstances: workflowInstances, setWorkflowInstances: setWorkflowInstances, isAllChecked: isAllChecked, setIsAllChecked: setIsAllChecked, driver: driver, defaultStatusFilter: defaultStatusFilter }),
        filters.status.length > 0 ? (React.createElement(React.Fragment, null,
            React.createElement(WorkflowListTable, { workflowInstances: workflowInstances, isLoading: isLoading, expanded: expanded, setExpanded: setExpanded, driver: driver, onSort: applySorting, sortBy: sortBy, setWorkflowInstances: setWorkflowInstances, selectedInstances: selectedInstances, setSelectedInstances: setSelectedInstances, selectableInstances: selectableInstances, setSelectableInstances: setSelectableInstances, setIsAllChecked: setIsAllChecked }),
            mustShowLoadMore && (React.createElement(LoadMore, { offset: offset, setOffset: setOffset, getMoreItems: (_offset, _limit) => {
                    setPageSize(_limit);
                    doQuery(_offset, _limit, false, true, true);
                }, pageSize: pageSize, isLoadingMore: isLoadingMore })))) : (React.createElement("div", { className: "kogito-workflow-list__emptyState-card" },
            React.createElement(KogitoEmptyState, { type: KogitoEmptyStateType.Reset, title: "No filters applied.", body: "Try applying at least one filter to see results", onClick: doResetFilters })))));
};
export default WorkflowList;
//# sourceMappingURL=WorkflowList.js.map