"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashbuilderEditor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var React = __importStar(require("react"));
var react_1 = require("react");
var Drawer_1 = require("@patternfly/react-core/dist/js/components/Drawer");
var api_1 = require("@kie-tools-core/workspace/dist/api");
var DashbuilderMonacoEditorApi_1 = require("../monaco/DashbuilderMonacoEditorApi");
var DashbuilderMonacoEditor_1 = require("../monaco/DashbuilderMonacoEditor");
var api_2 = require("@kie-tools-core/editor/dist/api");
var Dashbuilder_1 = require("../dashbuilder/Dashbuilder");
var Toolbar_1 = require("./Toolbar");
var INITIAL_CONTENT = "datasets:\n- uuid: products\n  content: >-\n            [\n              [\"Computers\", \"Scanner\", 5, 3],\n              [\"Computers\", \"Printer\", 7, 4],\n              [\"Computers\", \"Laptop\", 3, 2],\n              [\"Electronics\", \"Camera\", 10, 7],\n              [\"Electronics\", \"Headphones\", 5, 9]\n            ]\n  columns:\n    - id: Section\n      type: LABEL\n    - id: Product\n      type: LABEL\n    - id: Quantity\n      type: NUMBER\n    - id: Quantity2\n      type: NUMBER\npages:\n- components:\n    - html: Welcome to Dashbuilder!\n      properties:\n        font-size: xx-large\n        margin-bottom: 30px\n    - settings:\n        type: BARCHART\n        dataSetLookup:\n            uuid: products\n            group:\n                - columnGroup:\n                    source: Product\n                  groupFunctions:\n                    - source: Product\n                    - source: Quantity\n                      function: SUM\n                    - source: Quantity2\n                      function: SUM\n    - settings:\n        type: TABLE\n        dataSetLookup:\n            uuid: products";
var UPDATE_TIME = 1000;
var RefForwardingDashbuilderEditor = function (props, forwardedRef) {
    var _a = __read((0, react_1.useState)({ originalContent: INITIAL_CONTENT, path: "empty.dash.yml" }), 2), initialContent = _a[0], setInitialContent = _a[1];
    var _b = __read((0, react_1.useState)(""), 2), renderContent = _b[0], setRenderContent = _b[1];
    var _c = __read((0, react_1.useState)(false), 2), showPreview = _c[0], setShowPreview = _c[1];
    var dashbuilderMonacoEditorRef = (0, react_1.useRef)(null);
    (0, react_1.useEffect)(function () {
        var timer = setInterval(function () {
            var _a;
            setRenderContent(((_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.getContent()) || "");
        }, UPDATE_TIME);
        return function () { return clearTimeout(timer); };
    }, [renderContent]);
    var isVsCode = (0, react_1.useCallback)(function () {
        return props.channelType === api_2.ChannelType.VSCODE_DESKTOP || props.channelType === api_2.ChannelType.VSCODE_WEB;
    }, [props]);
    (0, react_1.useImperativeHandle)(forwardedRef, function () {
        return {
            setContent: function (normalizedPosixPathRelativeToTheWorkspaceRoot, newContent) {
                try {
                    setInitialContent({
                        originalContent: newContent,
                        path: normalizedPosixPathRelativeToTheWorkspaceRoot,
                    });
                    return Promise.resolve();
                }
                catch (e) {
                    console.error(e);
                    return Promise.reject();
                }
            },
            getContent: function () {
                var _a;
                return Promise.resolve(((_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.getContent()) || "");
            },
            getPreview: function () {
                return Promise.resolve("");
            },
            undo: function () {
                var _a;
                return ((_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo()) || Promise.resolve();
            },
            redo: function () {
                var _a;
                return ((_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.redo()) || Promise.resolve();
            },
            validate: function () {
                return [];
            },
            setTheme: function (theme) {
                var _a;
                return ((_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.setTheme(theme)) || Promise.resolve();
            },
            moveCursorToPosition: function (position) {
                var _a;
                (_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.moveCursorToPosition(position);
            },
        };
    }, []);
    var onContentChanged = (0, react_1.useCallback)(function (newContent, operation) {
        var _a, _b;
        if (operation === DashbuilderMonacoEditorApi_1.MonacoEditorOperation.EDIT) {
            props.onNewEdit(new api_1.WorkspaceEdit(newContent));
        }
        else if (operation === DashbuilderMonacoEditorApi_1.MonacoEditorOperation.UNDO) {
            if (!isVsCode()) {
                (_a = dashbuilderMonacoEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo();
            }
            props.onStateControlCommandUpdate(api_2.StateControlCommand.UNDO);
        }
        else if (operation === DashbuilderMonacoEditorApi_1.MonacoEditorOperation.REDO) {
            if (!isVsCode()) {
                (_b = dashbuilderMonacoEditorRef.current) === null || _b === void 0 ? void 0 : _b.redo();
            }
            props.onStateControlCommandUpdate(api_2.StateControlCommand.REDO);
        }
    }, [props, isVsCode]);
    (0, react_1.useEffect)(function () {
        props.onReady.call(null);
        onContentChanged(initialContent.originalContent);
    }, [initialContent, onContentChanged, props.onReady]);
    var panelContent = ((0, jsx_runtime_1.jsx)(Drawer_1.DrawerPanelContent, __assign({ isResizable: true, defaultSize: showPreview ? "100%" : "50%" }, { children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerPanelBody, __assign({ hasNoPadding: true }, { children: (0, jsx_runtime_1.jsx)(Dashbuilder_1.Dashbuilder, { content: renderContent }) })) })));
    return ((0, jsx_runtime_1.jsxs)("div", __assign({ style: { height: "100vh", position: "relative" } }, { children: [(0, jsx_runtime_1.jsx)(Toolbar_1.Toolbar, { onPreviewChange: function (v) { return setShowPreview(v); }, preview: showPreview }), (0, jsx_runtime_1.jsx)(Drawer_1.Drawer, __assign({ isExpanded: true, isInline: true }, { children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerContent, __assign({ panelContent: panelContent }, { children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerContentBody, __assign({ style: { overflow: "hidden" } }, { children: initialContent.path !== "" && ((0, jsx_runtime_1.jsx)(DashbuilderMonacoEditor_1.DashbuilderMonacoEditor, { channelType: props.channelType, content: initialContent.originalContent, fileName: initialContent.path, onContentChange: onContentChanged, ref: dashbuilderMonacoEditorRef })) })) })) }))] })));
};
exports.DashbuilderEditor = React.forwardRef(RefForwardingDashbuilderEditor);
//# sourceMappingURL=DashbuilderEditor.js.map