var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from "react";
import { useCallback, useMemo } from "react";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { connectField } from "uniforms";
import wrapField from "@kie-tools/uniforms-patternfly/dist/esm/wrapField";
function DmnFeelContext(_a) {
    var _b;
    var { onChange } = _a, props = __rest(_a, ["onChange"]);
    const stringifiedValue = useMemo(() => {
        if (props.value && typeof props.value === "object") {
            return JSON.stringify(props.value);
        }
        return props.value;
    }, [props.value]);
    const onTextInputChange = useCallback((value, event) => {
        try {
            const parsedObject = JSON.parse(event.target.value);
            onChange(parsedObject);
        }
        catch (err) {
            onChange(event.target.value);
        }
    }, [onChange]);
    return wrapField(props, React.createElement(React.Fragment, null,
        React.createElement(TextInput, { "aria-label": "uniforms context field", name: props.name, isDisabled: props.disabled, validated: props.error ? "error" : "default", onChange: onTextInputChange, placeholder: props.placeholder, ref: props.inputRef, type: (_b = props.type) !== null && _b !== void 0 ? _b : "text", value: stringifiedValue !== null && stringifiedValue !== void 0 ? stringifiedValue : "" })));
}
export const DmnFeelContextField = connectField(DmnFeelContext);
//# sourceMappingURL=DmnFeelContextField.js.map