"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractFunctions = exports.parseOpenApi = void 0;
var api_1 = require("../../../../api");
var lodash_1 = require("lodash");
var convertSource_1 = require("../convertSource");
var APPLICATION_JSON = "application/json";
function parseOpenApi(args, serviceOpenApiDocument) {
    var _a;
    var swfServiceCatalogFunctions = extractFunctions(serviceOpenApiDocument, (0, convertSource_1.convertSource)(args.source));
    return {
        name: (_a = serviceOpenApiDocument.info.title) !== null && _a !== void 0 ? _a : args.serviceFileName,
        type: api_1.SwfServiceCatalogServiceType.rest,
        source: args.source,
        functions: swfServiceCatalogFunctions,
        rawContent: args.serviceFileContent,
    };
}
exports.parseOpenApi = parseOpenApi;
function extractFunctions(serviceOpenApiDocument, source) {
    var swfServiceCatalogFunctions = Object.entries(serviceOpenApiDocument.paths).map(function (_a) {
        var _b = __read(_a, 2), endpoint = _b[0], pathItem = _b[1];
        return extractPathItemFunctions(pathItem, endpoint, serviceOpenApiDocument, source);
    });
    return [].concat.apply([], swfServiceCatalogFunctions);
}
exports.extractFunctions = extractFunctions;
function extractPathItemFunctions(pathItem, endpoint, serviceOpenApiDocument, source) {
    var swfServiceCatalogFunctions = [];
    Object.values(pathItem).forEach(function (pathOperation) {
        var _a, _b;
        var body = pathOperation.requestBody;
        var responses = pathOperation.responses;
        var response = responses["200"];
        var name = pathOperation.operationId;
        var functionArguments = {};
        if (pathOperation.parameters) {
            extractFunctionArgumentsFromParams(pathOperation.parameters, functionArguments);
        }
        if (body && body.content && body.content[APPLICATION_JSON] && body.content[APPLICATION_JSON].schema) {
            extractFunctionArgumentsFromBody((_a = body.content[APPLICATION_JSON].schema) !== null && _a !== void 0 ? _a : {}, serviceOpenApiDocument, functionArguments);
        }
        if (response &&
            response.content &&
            response.content[APPLICATION_JSON] &&
            response.content[APPLICATION_JSON].schema) {
            extractFunctionArgumentsFromBody((_b = response.content[APPLICATION_JSON].schema) !== null && _b !== void 0 ? _b : {}, serviceOpenApiDocument, functionArguments);
        }
        var swfServiceCatalogFunction = {
            source: source,
            name: name,
            type: api_1.SwfServiceCatalogFunctionType.rest,
            arguments: functionArguments,
        };
        swfServiceCatalogFunctions.push(swfServiceCatalogFunction);
    });
    return swfServiceCatalogFunctions;
}
function extractFunctionArgumentsFromParams(pathParams, functionParams) {
    pathParams.forEach(function (pathParam) {
        var name = (0, lodash_1.get)(pathParam, "name");
        var type = (0, lodash_1.get)(pathParam, "schema.type");
        if (name && type) {
            functionParams[name] = resolveArgumentType(type);
        }
    });
}
function extractFunctionArgumentsFromBody(schema, doc, functionParams) {
    var schemaObject = extractSchemaObject(schema, doc);
    if (schemaObject.properties) {
        Object.entries(schemaObject.properties).forEach(function (_a) {
            var _b = __read(_a, 2), propertyName = _b[0], propertySchema = _b[1];
            var asReference = propertySchema;
            if (asReference.$ref) {
                functionParams[propertyName] = api_1.SwfServiceCatalogFunctionArgumentType.object;
            }
            else {
                var asSchema = propertySchema;
                if (asSchema.type) {
                    functionParams[propertyName] = resolveArgumentType(asSchema.type);
                }
            }
        });
    }
}
function extractSchemaObject(schema, doc) {
    var _a, _b, _c;
    var asReference = schema;
    if (asReference.$ref) {
        var schemaRef = (_a = asReference.$ref.split("/").pop()) !== null && _a !== void 0 ? _a : "";
        var resolvedSchema = ((_b = doc.components) === null || _b === void 0 ? void 0 : _b.schemas) ? (_c = doc.components) === null || _c === void 0 ? void 0 : _c.schemas[schemaRef] : {};
        return extractSchemaObject(resolvedSchema, doc);
    }
    return schema;
}
function resolveArgumentType(type) {
    switch (type) {
        case "boolean":
            return api_1.SwfServiceCatalogFunctionArgumentType.boolean;
        case "object":
            return api_1.SwfServiceCatalogFunctionArgumentType.object;
        case "number":
            return api_1.SwfServiceCatalogFunctionArgumentType.number;
        case "string":
            return api_1.SwfServiceCatalogFunctionArgumentType.string;
        case "integer":
            return api_1.SwfServiceCatalogFunctionArgumentType.integer;
        case "array":
            return api_1.SwfServiceCatalogFunctionArgumentType.array;
    }
    return api_1.SwfServiceCatalogFunctionArgumentType.object;
}
//# sourceMappingURL=openapi.js.map