var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { getJobsWithFilters, handleJobReschedule, jobCancel, performMultipleCancel, } from "@kie-tools/runtime-tools-process-gateway-api/dist/gatewayApi";
export class GraphQLJobsManagementQueries {
    constructor(client) {
        this.client = client;
    }
    getJobs(offset, limit, filters, orderBy) {
        return __awaiter(this, void 0, void 0, function* () {
            return getJobsWithFilters(offset, limit, filters, orderBy, this.client);
        });
    }
    cancelJob(job) {
        return __awaiter(this, void 0, void 0, function* () {
            return jobCancel(job, this.client);
        });
    }
    bulkCancel(jobsToBeActioned) {
        return __awaiter(this, void 0, void 0, function* () {
            return performMultipleCancel(jobsToBeActioned, this.client);
        });
    }
    rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate) {
        return __awaiter(this, void 0, void 0, function* () {
            return handleJobReschedule(job, repeatInterval, repeatLimit, scheduleDate, this.client);
        });
    }
}
//# sourceMappingURL=JobsManagementQueries.js.map