import { IdentifiersRepository } from "@kie-tools/dmn-feel-antlr4-parser/dist";
import { FeelIdentifiersParser } from "@kie-tools/dmn-feel-antlr4-parser/dist";
export class IdentifiersRefactor {
    constructor(args) {
        this.repository = new IdentifiersRepository(args.writeableDmnDefinitions, args._readonly_externalDmnModelsByNamespaceMap);
        this.computeIdentifiersLinksToExpressions();
    }
    get expressions() {
        return this.repository.expressions;
    }
    get identifiers() {
        return this.repository.identifiers;
    }
    reload() {
        this.repository.reload();
        this.computeIdentifiersLinksToExpressions();
    }
    changeType(args) {
        const context = this.repository.identifiersContextIndexedByUuid.get(args.identifierUuid);
        if (context) {
            context.identifier.typeRef = this.repository.getTypeRef(args.newType);
            if (context.identifier.applyTypeRefToSource) {
                context.identifier.applyTypeRefToSource();
            }
        }
        this.applyExpressionsChangesToDefinition();
    }
    rename(args) {
        const context = this.repository.identifiersContextIndexedByUuid.get(args.identifierUuid);
        if (context) {
            for (const expression of context.identifier.expressionsThatUseTheIdentifier.values()) {
                expression.renameIdentifier(context.identifier, args.newName);
            }
            context.identifier.value = args.newName;
            if (context.identifier.applyValueToSource) {
                context.identifier.applyValueToSource();
            }
        }
        else {
            const dataType = this.repository.dataTypeIndexedByUuid.get(args.identifierUuid);
            if (dataType) {
                for (const expression of dataType.source.expressionsThatUseTheIdentifier.values()) {
                    expression.renameIdentifier(dataType.source, args.newName);
                }
                dataType.source.value = args.newName;
            }
        }
        this.applyExpressionsChangesToDefinition();
    }
    renameImport(args) {
        const importedIdentifiers = this.repository.importedIdentifiers.get(args.oldName);
        if (importedIdentifiers) {
            for (const imported of importedIdentifiers) {
                const newName = imported.identifier.value.replace(args.oldName + ".", args.newName + ".");
                for (const expression of imported.identifier.expressionsThatUseTheIdentifier.values()) {
                    expression.renameIdentifier(imported.identifier, newName);
                }
                imported.identifier.value = newName;
            }
            this.repository.importedIdentifiers.delete(args.oldName);
            this.repository.importedIdentifiers.set(args.newName, importedIdentifiers);
        }
        const importedDataTypes = this.repository.importedDataTypes.get(args.oldName);
        if (importedDataTypes) {
            for (const imported of importedDataTypes) {
                const newDataTypeName = imported.source.value.replace(args.oldName + ".", args.newName + ".");
                for (const expression of imported.source.expressionsThatUseTheIdentifier.values()) {
                    expression.renameIdentifier(imported.source, newDataTypeName);
                }
                imported.source.value = newDataTypeName;
            }
            this.repository.importedDataTypes.delete(args.oldName);
            this.repository.importedDataTypes.set(args.newName, importedDataTypes);
        }
        this.applyExpressionsChangesToDefinition();
    }
    getExpressionsThatUseTheIdentifier(identifierId) {
        var _a, _b;
        const identifierContext = this.repository.identifiers.get(identifierId);
        if (!identifierContext) {
            return ((_b = (_a = this.repository.dataTypeIndexedByUuid.get(identifierId)) === null || _a === void 0 ? void 0 : _a.source.expressionsThatUseTheIdentifier.values()) !== null && _b !== void 0 ? _b : []);
        }
        return identifierContext.identifier.expressionsThatUseTheIdentifier.values();
    }
    computeIdentifiersLinksToExpressions() {
        var _a, _b;
        const parser = new FeelIdentifiersParser(this.repository);
        for (const expression of this.repository.expressions.values()) {
            for (const identifier of expression.identifiersOfTheExpression) {
                (_a = identifier.source) === null || _a === void 0 ? void 0 : _a.expressionsThatUseTheIdentifier.delete(expression.uuid);
            }
            const parsedExpression = parser.parse(expression.uuid, expression.fullExpression);
            expression.identifiersOfTheExpression = parsedExpression.feelIdentifiedSymbols;
            for (const feelIdentifiedSymbol of parsedExpression.feelIdentifiedSymbols) {
                (_b = feelIdentifiedSymbol.source) === null || _b === void 0 ? void 0 : _b.expressionsThatUseTheIdentifier.set(expression.uuid, expression);
            }
        }
    }
    applyExpressionsChangesToDefinition() {
        for (const expression of this.expressions.values()) {
            expression.applyChangesToExpressionSource();
        }
    }
}
//# sourceMappingURL=IdentifiersRefactor.js.map