import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useMemo, useState } from "react";
import useOnclickOutside from "react-cool-onclickoutside";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Select, SelectOption, SelectVariant, } from "@patternfly/react-core/dist/js/components/Select";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
import { ArrowAltCircleRightIcon } from "@patternfly/react-icons/dist/js/icons/arrow-alt-circle-right-icon";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import "./DataTypeItem.scss";
import ConstraintsLabel from "../ConstraintsLabel/ConstraintsLabel";
import PropertiesLabels from "../PropertiesLabels/PropertiesLabels";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import { ValidationIndicator } from "../../EditorCore/atoms";
const DataTypeItem = (props) => {
    const { dataType, index, editingIndex, onSave, onEdit, onDelete, onConstraintsEdit, onConstraintsSave, onValidate, onOutsideClick, } = props;
    const [name, setName] = useState(dataType.name);
    const [typeSelection, setTypeSelection] = useState(dataType.type);
    const [isTypeSelectOpen, setIsTypeSelectOpen] = useState(false);
    const typeOptions = [
        { value: "string" },
        { value: "integer" },
        { value: "float" },
        { value: "double" },
        { value: "boolean" },
    ];
    const [optypeSelection, setOptypeSelection] = useState(dataType.optype);
    const [isOptypeSelectOpen, setIsOptypeSelectOpen] = useState(false);
    const optypeOptions = [{ value: "categorical" }, { value: "ordinal" }, { value: "continuous" }];
    const [validation, setValidation] = useState("default");
    const ref = useOnclickOutside(() => {
        onOutsideClick();
    }, { eventTypes: ["click"], disabled: editingIndex !== index });
    const handleNameChange = (value) => {
        setName(value);
        setValidation(onValidate(value) ? "default" : "error");
    };
    const typeToggle = (isOpen) => {
        setIsTypeSelectOpen(isOpen);
    };
    const typeSelect = (event, value) => {
        if (value !== typeSelection) {
            setTypeSelection(value);
            setIsTypeSelectOpen(false);
            onSave({ ...dataType, type: value }, index);
        }
    };
    const optypeToggle = (isOpen) => {
        setIsOptypeSelectOpen(isOpen);
    };
    const optypeSelect = (event, value) => {
        if (value !== optypeSelection) {
            setOptypeSelection(value);
            setIsOptypeSelectOpen(false);
            onSave({ ...dataType, optype: value }, index);
        }
    };
    const handleEditStatus = (event) => {
        event.preventDefault();
        event.stopPropagation();
        onEdit === null || onEdit === void 0 ? void 0 : onEdit(index);
    };
    const handleSave = (event) => {
        event === null || event === void 0 ? void 0 : event.preventDefault();
        onSave({ name: name.trim(), type: typeSelection, optype: optypeSelection }, index);
    };
    const handleNameSave = () => {
        if (validation === "error") {
            setName(dataType.name);
            setValidation("default");
        }
        else if (name !== dataType.name) {
            handleSave();
        }
    };
    const handleDelete = (event, interaction) => {
        event.stopPropagation();
        event.preventDefault();
        if (onDelete) {
            onDelete(index, interaction);
        }
    };
    const handleConstraints = () => {
        onConstraintsEdit({ ...dataType, name, type: typeSelection });
    };
    const handleConstraintsDelete = () => {
        const updatedDataType = { ...dataType };
        delete updatedDataType.constraints;
        onConstraintsSave(updatedDataType);
    };
    const handlePropertiesDelete = (updatedDataType, updateIndex) => {
        onSave(updatedDataType, updateIndex);
    };
    useEffect(() => {
        if (editingIndex === index) {
            const input = document.querySelector(`.data-type-item-n${index} #name`);
            input === null || input === void 0 ? void 0 : input.focus();
            if (name.startsWith("New Data Type")) {
                input === null || input === void 0 ? void 0 : input.select();
            }
        }
        else {
            if (validation !== "success") {
                setName(dataType.name);
                setValidation("default");
            }
        }
    }, [editingIndex]);
    useEffect(() => {
        setName(dataType.name);
        setTypeSelection(dataType.type);
        setOptypeSelection(dataType.optype);
    }, [dataType]);
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder().forDataDictionary().forDataField(index).build()), [index, dataType]);
    return (_jsxs("article", { id: `data-type-item-n${index}`, "data-testid": `data-type-item-n${index}`, className: `editable-item ${editingIndex === index ? "editable-item--editing" : ""} data-type-item-n${index}`, "data-ouia-component-id": name, "data-ouia-component-type": "dd-type-item", tabIndex: 0, children: [editingIndex === index && (_jsx("section", { className: "editable-item__inner", ref: ref, onKeyDown: (event) => {
                    if (event.key === "Escape") {
                        onOutsideClick();
                    }
                }, children: _jsx(Form, { onSubmit: (e) => {
                        e.stopPropagation();
                        e.preventDefault();
                    }, children: _jsx(Split, { hasGutter: true, children: _jsx(SplitItem, { children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(FormGroup, { fieldId: "name", label: "Name", helperTextInvalid: "Name is mandatory and must be unique", helperTextInvalidIcon: _jsx(ExclamationCircleIcon, {}), validated: validation, style: { width: 280 }, isRequired: true, "data-ouia-component-type": "field-name", children: _jsx(TextInput, { type: "text", id: "name", name: "name", value: name, onChange: handleNameChange, placeholder: "Name", validated: validation, onBlur: handleNameSave, autoComplete: "off" }) }) }), _jsx(SplitItem, { children: _jsx(FormGroup, { fieldId: "type", label: "Type", isRequired: true, "data-ouia-component-type": "field-type", children: _jsx(Select, { id: "type", variant: SelectVariant.single, "aria-label": "Select Input Type", onToggle: typeToggle, onSelect: typeSelect, selections: typeSelection, isOpen: isTypeSelectOpen, placeholder: "Type", className: "data-type-item__type-select", menuAppendTo: "parent", children: typeOptions.map((option, optionIndex) => (_jsx(SelectOption, { value: option.value, className: "ignore-onclickoutside data-type-item__type-select__option", "data-ouia-component-type": "select-option" }, optionIndex))) }) }) }), _jsx(SplitItem, { children: _jsx(FormGroup, { fieldId: "optype", label: "Op Type", isRequired: true, "data-ouia-component-type": "field-optype", children: _jsx(Select, { id: "optype", variant: SelectVariant.single, "aria-label": "Select Op Type", onToggle: optypeToggle, onSelect: optypeSelect, selections: optypeSelection, isOpen: isOptypeSelectOpen, placeholder: "Op Type", className: "data-type-item__type-select", menuAppendTo: "parent", children: optypeOptions.map((option, optionIndex) => (_jsx(SelectOption, { value: option.value, className: "ignore-onclickoutside data-type-item__type-select__option", "data-ouia-component-type": "select-option" }, optionIndex))) }) }) }), _jsx(SplitItem, { isFilled: true, children: "\u00A0" })] }) }), _jsx(StackItem, { children: _jsx(Split, { hasGutter: true, children: _jsxs(SplitItem, { children: [_jsx(PropertiesLabels, { dataType: dataType, editingIndex: editingIndex, onPropertyDelete: handlePropertiesDelete }), _jsx(ConstraintsLabel, { dataType: dataType, dataTypeIndex: index, editMode: true, onConstraintsDelete: handleConstraintsDelete }), _jsx(Label, { variant: "outline", color: "cyan", href: "#", icon: _jsx(ArrowAltCircleRightIcon, {}), onClick: (event) => {
                                                            event.preventDefault();
                                                            handleConstraints();
                                                        }, "data-ouia-component-id": "edit-props", "data-ouia-component-type": "link-label", children: "Edit Properties" })] }) }) })] }) }) }) }) })), editingIndex !== index && (_jsx("section", { className: "editable-item__inner", onClick: handleEditStatus, onKeyDown: (event) => {
                    if (event.key === "Enter") {
                        handleEditStatus(event);
                    }
                }, children: _jsxs(Split, { hasGutter: true, children: [validations.length > 0 && (_jsx(SplitItem, { children: _jsx(Flex, { alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentCenter" }, style: { height: "100%" }, children: _jsx(FlexItem, { children: _jsx(ValidationIndicator, { validations: validations }) }) }) })), _jsx(SplitItem, { children: _jsx("span", { className: "data-type-item__name", children: name }) }), _jsxs(SplitItem, { isFilled: true, children: [_jsx(Label, { color: "blue", className: "data-type-item__type-label", "data-ouia-component-id": typeSelection, "data-ouia-component-type": "data-type-label", children: typeSelection }), " ", _jsx(Label, { color: "blue", className: "data-type-item__type-label", "data-ouia-component-id": optypeSelection, "data-ouia-component-type": "data-optype-label", children: optypeSelection }), " ", _jsx(PropertiesLabels, { dataType: dataType }), _jsx(ConstraintsLabel, { dataType: dataType, dataTypeIndex: index })] }), _jsx(SplitItem, { children: _jsx(Button, { id: `data-type-item-n${index}__delete`, "data-testid": `data-type-item-n${index}__delete`, ouiaId: "delete-field", className: "editable-item__delete", variant: "plain", onClick: (e) => handleDelete(e, "mouse"), onKeyDown: (event) => {
                                    if (event.key === "Enter") {
                                        handleDelete(event, "keyboard");
                                    }
                                }, children: _jsx(TrashIcon, {}) }) })] }) }))] }));
};
export default DataTypeItem;
//# sourceMappingURL=DataTypeItem.js.map