import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useEffect, useMemo, useState } from "react";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Attribute, Scorecard, } from "@kie-tools/pmml-editor-marshaller";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import { PredicateEditor } from "./PredicateEditor";
import { Operation } from "../Operation";
import { useSelector } from "react-redux";
import { isEqual } from "lodash";
import useOnclickOutside from "react-cool-onclickoutside";
import { useOperation } from "../OperationContext";
import { fromText, toText } from "../organisms";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import "./AttributeEditor.scss";
import { ValidationIndicator } from "../../EditorCore/atoms";
var set = Reflect.set;
var get = Reflect.get;
export const AttributeEditor = (props) => {
    const { modelIndex, characteristicIndex, attributeIndex, areReasonCodesUsed, onCancel, onCommit } = props;
    const [text, setText] = useState();
    const [partialScore, setPartialScore] = useState();
    const [reasonCode, setReasonCode] = useState();
    const [originalText, setOriginalText] = useState();
    const { activeOperation } = useOperation();
    const dataFields = useSelector((state) => {
        return state.DataDictionary.DataField;
    });
    const characteristic = useSelector((state) => {
        const model = state.models ? state.models[modelIndex] : undefined;
        if (model instanceof Scorecard && characteristicIndex !== undefined) {
            return model.Characteristics.Characteristic[characteristicIndex];
        }
    });
    const attribute = useMemo(() => {
        return characteristic && attributeIndex !== undefined
            ? characteristic.Attribute[attributeIndex]
            : new Attribute({});
    }, [characteristic, attributeIndex]);
    const commit = (partial) => {
        const existingPartial = {};
        Object.keys(partial).forEach((key) => set(existingPartial, key, get(attribute, key)));
        if (!isEqual(partial, existingPartial)) {
            onCommit(attributeIndex, { ...attribute, ...partial });
        }
    };
    const ref = useOnclickOutside(() => {
        if (text !== originalText) {
            commit({ predicate: fromText(text) });
        }
    }, {
        disabled: activeOperation !== Operation.UPDATE_ATTRIBUTE,
        eventTypes: ["mousedown"],
    });
    const { validationRegistry } = useValidationRegistry();
    const reasonCodeValidation = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forAttribute(attributeIndex)
        .forReasonCode()
        .build()), [modelIndex, characteristicIndex, areReasonCodesUsed, attribute.reasonCode]);
    const partialScoreValidation = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forAttribute(attributeIndex)
        .forPartialScore()
        .build()), [modelIndex, characteristicIndex, attribute.partialScore]);
    const predicateValidation = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forAttribute(attributeIndex)
        .forPredicate()
        .build()), [modelIndex, characteristicIndex, attribute.predicate]);
    useEffect(() => {
        const _text = toText(attribute.predicate, dataFields);
        setText(_text);
        setPartialScore(attribute.partialScore);
        setReasonCode(attribute.reasonCode);
        setOriginalText(_text);
    }, [modelIndex, characteristicIndex, attributeIndex, attribute.predicate]);
    const toNumber = (value) => {
        if (value === "") {
            return undefined;
        }
        const n = Number(value);
        if (isNaN(n)) {
            return undefined;
        }
        return n;
    };
    return (_jsx("article", { tabIndex: 0, "data-ouia-component-id": "edit-attribute", children: _jsx(Form, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { isFilled: true, children: _jsx(FormGroup, { label: "Predicate", isRequired: true, fieldId: "attribute-predicate-helper", validated: predicateValidation.length > 0 ? "warning" : "default", children: _jsxs("div", { ref: ref, "data-ouia-component-id": "predicate", children: [_jsx(PredicateEditor, { text: text, setText: setText }), _jsxs(_Fragment, { children: [predicateValidation.length > 0 && (_jsxs("div", { children: [_jsx(ValidationIndicator, { validations: predicateValidation }), _jsx("span", { className: "pf-c-form__helper-text pf-m-warning attribute-editor__validation-message", children: predicateValidation[0].message })] })), predicateValidation.length === 0 && (_jsx("div", { className: "pf-c-form__helper-text", children: "The condition upon which the mapping between input attribute and partial score takes place." }))] })] }) }) }), _jsx(SplitItem, { children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsx(FormGroup, { label: "Reason code", fieldId: "attribute-reason-code-helper", validated: reasonCodeValidation.length > 0 ? "warning" : "default", helperText: reasonCodeValidation.length > 0
                                            ? reasonCodeValidation[0].message
                                            : "A Reason Code is mapped to a Business reason.", labelIcon: _jsx(Tooltip, { content: areReasonCodesUsed && (characteristic === null || characteristic === void 0 ? void 0 : characteristic.reasonCode) !== undefined
                                                ? `Reason code already provided at the Characteristic level (${characteristic.reasonCode})`
                                                : `When Use Reason Codes is set to yes in the Model Setup, a reason code must be provided \
                              for characteristics or it must be provided for all its attributes.`, children: _jsx("button", { "aria-label": "More information for Partial Score", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), children: _jsx(TextInput, { type: "text", id: "attribute-reason-code", name: "attribute-reason-code", "aria-describedby": "attribute-reason-code-helper", value: reasonCode !== null && reasonCode !== void 0 ? reasonCode : "", onChange: (e) => setReasonCode(e), onBlur: () => {
                                                commit({ reasonCode: reasonCode !== "" ? reasonCode : undefined });
                                            }, validated: reasonCodeValidation.length > 0 ? "warning" : "default", isDisabled: !areReasonCodesUsed || (characteristic === null || characteristic === void 0 ? void 0 : characteristic.reasonCode) !== undefined, ouiaId: "attribute-reason-code" }) }) }), _jsx(StackItem, { children: _jsx(FormGroup, { label: "Partial score", fieldId: "attribute-partial-score-helper", validated: partialScoreValidation.length > 0 ? "warning" : "default", helperText: partialScoreValidation.length > 0
                                            ? partialScoreValidation[0].message
                                            : "Defines the score points awarded to the Attribute.", labelIcon: _jsx(Tooltip, { content: "If one of the Attributes of a Characteristic provides a Partial score value, all the attributes are required to provide a Partial score as well.", children: _jsx("button", { "aria-label": "More information for Partial Score", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), children: _jsx(TextInput, { type: "number", id: "attribute-partial-score", name: "attribute-partial-score", "aria-describedby": "attribute-partial-score-helper", value: partialScore !== null && partialScore !== void 0 ? partialScore : "", onChange: (e) => setPartialScore(toNumber(e)), onBlur: () => {
                                                commit({
                                                    partialScore: partialScore,
                                                });
                                            }, validated: partialScoreValidation.length > 0 ? "warning" : "default", ouiaId: "attribute-partial-score" }) }) })] }) })] }) }) }));
};
//# sourceMappingURL=AttributeEditor.js.map