import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useEffect, useRef, useState } from "react";
import { PopoverMenu } from "../contextMenu/PopoverMenu";
import { useBoxedExpressionEditorI18n } from "../i18n";
import { useBoxedExpressionEditor } from "../BoxedExpressionEditorContext";
import { DataTypeSelector } from "./DataTypeSelector";
import { CogIcon } from "@patternfly/react-icons/dist/js/icons/cog-icon";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { NavigationKeysUtils } from "../keysUtils/keyUtils";
import "./ExpressionVariableMenu.css";
import { Action } from "../api";
import { getOperatingSystem, OperatingSystem } from "@kie-tools-core/operating-system";
import { FeelInputTextbox } from "./FeelInputTextbox";
export const DEFAULT_EXPRESSION_VARIABLE_NAME = "Expression Name";
export function ExpressionVariableMenu({ children, appendTo, arrowPlacement, nameField, dataTypeField, selectedDataType = undefined, selectedExpressionName, onVariableUpdated, position, variableUuid, isContentAFeelExpression = false, }) {
    var _a;
    const { editorRef, beeGwtService } = useBoxedExpressionEditor();
    const { i18n } = useBoxedExpressionEditorI18n();
    nameField = (nameField !== null && nameField !== void 0 ? nameField : isContentAFeelExpression) ? i18n.expression : i18n.name;
    dataTypeField = dataTypeField !== null && dataTypeField !== void 0 ? dataTypeField : i18n.dataType;
    appendTo = (_a = appendTo !== null && appendTo !== void 0 ? appendTo : editorRef === null || editorRef === void 0 ? void 0 : editorRef.current) !== null && _a !== void 0 ? _a : undefined;
    const [dataType, setDataType] = useState(selectedDataType);
    const [expressionName, setExpressionName] = useState(selectedExpressionName);
    const expressionNameRef = useRef(null);
    const popoverMenuRef = useRef();
    useEffect(() => {
        setExpressionName(selectedExpressionName);
    }, [selectedExpressionName]);
    useEffect(() => {
        setDataType(selectedDataType);
    }, [selectedDataType]);
    const onExpressionNameChange = useCallback((event) => {
        setExpressionName(event.target.value);
    }, []);
    const onDataTypeChange = useCallback((dataType) => {
        setDataType(dataType);
    }, []);
    const openDataTypePage = useCallback(() => {
        return beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.openDataTypePage();
    }, [beeGwtService]);
    const saveExpression = useCallback(() => {
        const expressionChangedArgs = {
            action: Action.VariableChanged,
            variableUuid: variableUuid,
            typeChange: dataType !== selectedDataType
                ? {
                    from: dataType,
                    to: selectedDataType,
                }
                : undefined,
            nameChange: expressionName !== selectedExpressionName
                ? {
                    from: expressionName,
                    to: selectedExpressionName,
                }
                : undefined,
        };
        if (expressionChangedArgs.nameChange || expressionChangedArgs.typeChange) {
            onVariableUpdated({ name: expressionName, typeRef: dataType, changes: expressionChangedArgs });
        }
    }, [expressionName, selectedExpressionName, dataType, selectedDataType, variableUuid, onVariableUpdated]);
    const resetFormData = useCallback(() => {
        setExpressionName(selectedExpressionName);
        setDataType(selectedDataType);
    }, [selectedExpressionName, selectedDataType]);
    const cancelEdit = useRef(false);
    const onHide = useCallback(() => {
        var _a;
        if (cancelEdit.current) {
            cancelEdit.current = false;
            return;
        }
        saveExpression();
        (_a = popoverMenuRef === null || popoverMenuRef === void 0 ? void 0 : popoverMenuRef.current) === null || _a === void 0 ? void 0 : _a.setIsVisible(false);
    }, [saveExpression]);
    const onCancel = useCallback(() => {
        var _a;
        cancelEdit.current = true;
        resetFormData();
        (_a = popoverMenuRef === null || popoverMenuRef === void 0 ? void 0 : popoverMenuRef.current) === null || _a === void 0 ? void 0 : _a.setIsVisible(false);
    }, [resetFormData]);
    const onShown = useCallback(() => {
        var _a;
        setExpressionName(selectedExpressionName);
        (_a = expressionNameRef.current) === null || _a === void 0 ? void 0 : _a.focus();
    }, [selectedExpressionName]);
    const onKeyDown = useCallback((e) => {
        var _a, _b;
        if (!(getOperatingSystem() === OperatingSystem.MACOS && e.metaKey)) {
            e.stopPropagation();
        }
        if (NavigationKeysUtils.isEnter(e.key)) {
            saveExpression();
            (_a = popoverMenuRef === null || popoverMenuRef === void 0 ? void 0 : popoverMenuRef.current) === null || _a === void 0 ? void 0 : _a.setIsVisible(false);
        }
        else if (NavigationKeysUtils.isEsc(e.key)) {
            resetFormData();
            (_b = popoverMenuRef === null || popoverMenuRef === void 0 ? void 0 : popoverMenuRef.current) === null || _b === void 0 ? void 0 : _b.setIsVisible(false);
        }
    }, [resetFormData, saveExpression]);
    return (_jsx(PopoverMenu, { ref: popoverMenuRef, arrowPlacement: arrowPlacement, appendTo: appendTo, onCancel: onCancel, onHide: onHide, onShown: onShown, position: position, distance: 25, body: _jsxs("div", { className: "edit-expression-menu", onKeyDown: onKeyDown, onMouseDown: (e) => e.stopPropagation(), children: [_jsxs("div", { className: "expression-name", children: [_jsx("label", { children: nameField }), isContentAFeelExpression ? (_jsx(FeelInputTextbox, { value: expressionName, onChange: (e) => setExpressionName(e), expressionId: variableUuid })) : (_jsx("input", { ref: expressionNameRef, type: "text", id: "expression-name", "data-ouia-component-id": "edit-expression-name", value: expressionName, onChange: onExpressionNameChange, onBlur: onExpressionNameChange, className: "form-control pf-c-form-control", placeholder: DEFAULT_EXPRESSION_VARIABLE_NAME, onKeyDown: onKeyDown }))] }), _jsxs("div", { className: "expression-data-type", children: [_jsx("label", { children: dataTypeField }), _jsx(Button, { ouiaId: "manage-data-type-link", variant: "link", className: "manage-datatype", icon: _jsx(CogIcon, {}), iconPosition: "left", onClick: openDataTypePage, children: i18n.manage }), _jsx(DataTypeSelector, { value: dataType, onChange: onDataTypeChange, onKeyDown: onKeyDown })] })] }), children: children }));
}
//# sourceMappingURL=ExpressionVariableMenu.js.map