import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useMemo, useRef } from "react";
import { Action, BeeTableHeaderVisibility, BeeTableOperation, DmnBuiltInDataType, generateUuid, getNextAvailablePrefixedName, } from "../../api";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { usePublishedBeeTableResizableColumns } from "../../resizing/BeeTableResizableColumnsContext";
import { useApportionedColumnWidthsIfNestedTable, useNestedTableLastColumnMinWidth } from "../../resizing/Hooks";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { BEE_TABLE_ROW_INDEX_COLUMN_WIDTH, DECISION_TABLE_ANNOTATION_DEFAULT_WIDTH, DECISION_TABLE_ANNOTATION_MIN_WIDTH, DECISION_TABLE_INPUT_DEFAULT_WIDTH, DECISION_TABLE_INPUT_MIN_WIDTH, DECISION_TABLE_OUTPUT_DEFAULT_WIDTH, DECISION_TABLE_OUTPUT_MIN_WIDTH, } from "../../resizing/WidthConstants";
import { BeeTable, getColumnsAtLastLevel, } from "../../table/BeeTable";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { assertUnreachable } from "../ExpressionDefinitionRoot/ExpressionDefinitionLogicTypeSelector";
import { HIT_POLICIES_THAT_SUPPORT_AGGREGATION, HitPolicySelector } from "./HitPolicySelector";
import _ from "lodash";
import "./DecisionTableExpression.css";
var DecisionTableColumnType;
(function (DecisionTableColumnType) {
    DecisionTableColumnType["InputClause"] = "input";
    DecisionTableColumnType["OutputClause"] = "output";
    DecisionTableColumnType["Annotation"] = "annotation";
})(DecisionTableColumnType || (DecisionTableColumnType = {}));
export const DECISION_TABLE_INPUT_DEFAULT_VALUE = "-";
export const DECISION_TABLE_OUTPUT_DEFAULT_VALUE = "";
export const DECISION_TABLE_ANNOTATION_DEFAULT_VALUE = "";
function createInputEntry() {
    return {
        "@_id": generateUuid(),
        text: { __$$text: DECISION_TABLE_INPUT_DEFAULT_VALUE },
    };
}
function createOutputEntry() {
    return {
        "@_id": generateUuid(),
        text: { __$$text: DECISION_TABLE_OUTPUT_DEFAULT_VALUE },
    };
}
function createAnnotationEntry() {
    return {
        text: { __$$text: DECISION_TABLE_ANNOTATION_DEFAULT_VALUE },
    };
}
const createDefaultRule = () => {
    const defaultRowToAdd = {
        "@_id": generateUuid(),
        inputEntry: [
            {
                "@_id": generateUuid(),
                text: { __$$text: "-" },
            },
        ],
        outputEntry: [
            {
                "@_id": generateUuid(),
                text: { __$$text: "" },
            },
        ],
        annotationEntry: [{ text: { __$$text: "// Your annotations here" } }],
    };
    return defaultRowToAdd;
};
export function DecisionTableExpression({ isNested, expression: decisionTableExpression, }) {
    var _a, _b, _c, _d, _e;
    const { i18n } = useBoxedExpressionEditorI18n();
    const { expressionHolderId, widthsById, isReadOnly } = useBoxedExpressionEditor();
    const { setExpression, setWidthsById } = useBoxedExpressionEditorDispatch();
    const id = decisionTableExpression["@_id"];
    const widths = useMemo(() => { var _a; return (_a = widthsById.get(id)) !== null && _a !== void 0 ? _a : []; }, [id, widthsById]);
    const getInputIndexInTable = useCallback((localIndex) => {
        return 1 + localIndex;
    }, []);
    const getOutputIndexInTable = useCallback((localIndex) => {
        var _a, _b;
        return 1 + ((_b = (_a = decisionTableExpression.input) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) + localIndex;
    }, [(_a = decisionTableExpression.input) === null || _a === void 0 ? void 0 : _a.length]);
    const getAnnotationIndexInTable = useCallback((localIndex) => {
        var _a, _b, _c, _d;
        return (1 + ((_b = (_a = decisionTableExpression.input) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) + ((_d = (_c = decisionTableExpression.output) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0) + localIndex);
    }, [(_b = decisionTableExpression.input) === null || _b === void 0 ? void 0 : _b.length, (_c = decisionTableExpression.output) === null || _c === void 0 ? void 0 : _c.length]);
    const getInputWidth = useCallback((inputIndex, widths) => {
        const index = getInputIndexInTable(inputIndex);
        return { index, width: widths[index] };
    }, [getInputIndexInTable]);
    const getOutputWidth = useCallback((outputIndex, widths) => {
        const index = getOutputIndexInTable(outputIndex);
        return { index, width: widths[index] };
    }, [getOutputIndexInTable]);
    const getAnnotationWidth = useCallback((annotationIndex, widths) => {
        const index = getAnnotationIndexInTable(annotationIndex);
        return { index, width: widths[index] };
    }, [getAnnotationIndexInTable]);
    const generateOperationConfig = useCallback((groupName) => [
        {
            group: groupName,
            items: [
                { name: i18n.columnOperations.insertLeft, type: BeeTableOperation.ColumnInsertLeft },
                { name: i18n.columnOperations.insertRight, type: BeeTableOperation.ColumnInsertRight },
                { name: i18n.insert, type: BeeTableOperation.ColumnInsertN },
                { name: i18n.columnOperations.delete, type: BeeTableOperation.ColumnDelete },
            ],
        },
        {
            group: i18n.decisionRule,
            items: [
                { name: i18n.rowOperations.insertAbove, type: BeeTableOperation.RowInsertAbove },
                { name: i18n.rowOperations.insertBelow, type: BeeTableOperation.RowInsertBelow },
                { name: i18n.insert, type: BeeTableOperation.RowInsertN },
                { name: i18n.rowOperations.delete, type: BeeTableOperation.RowDelete },
                { name: i18n.rowOperations.duplicate, type: BeeTableOperation.RowDuplicate },
            ],
        },
        {
            group: i18n.terms.selection.toUpperCase(),
            items: [
                { name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy },
                { name: i18n.terms.cut, type: BeeTableOperation.SelectionCut },
                { name: i18n.terms.paste, type: BeeTableOperation.SelectionPaste },
                { name: i18n.terms.reset, type: BeeTableOperation.SelectionReset },
            ],
        },
    ], [i18n]);
    const beeTableOperationConfig = useMemo(() => {
        const config = {};
        config[""] = generateOperationConfig(i18n.outputClause);
        config[DecisionTableColumnType.InputClause] = generateOperationConfig(i18n.inputClause);
        config[DecisionTableColumnType.OutputClause] = generateOperationConfig(i18n.outputClause);
        config[DecisionTableColumnType.Annotation] = generateOperationConfig(i18n.ruleAnnotation);
        return config;
    }, [generateOperationConfig, i18n.inputClause, i18n.outputClause, i18n.ruleAnnotation]);
    const getEditColumnLabel = useMemo(() => {
        const editColumnLabel = {};
        editColumnLabel[DecisionTableColumnType.InputClause] = i18n.editClause.input;
        editColumnLabel[DecisionTableColumnType.OutputClause] = i18n.editClause.output;
        return editColumnLabel;
    }, [i18n]);
    const setInputColumnWidth = useCallback((inputIndex) => (newWidthAction) => {
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const inputWidth = getInputWidth(inputIndex, prev);
            const newWidth = typeof newWidthAction === "function" ? newWidthAction(inputWidth === null || inputWidth === void 0 ? void 0 : inputWidth.width) : newWidthAction;
            if (newWidth && inputWidth) {
                const minSize = inputWidth.index + 1;
                const newValues = [...prev];
                newValues.push(...Array(Math.max(0, minSize - newValues.length)).fill(DECISION_TABLE_INPUT_MIN_WIDTH));
                newValues.splice(inputWidth.index, 1, newWidth);
                newMap.set(id, newValues);
            }
        });
    }, [id, getInputWidth, setWidthsById]);
    const setOutputColumnWidth = useCallback((outputIndex) => (newWidthAction) => {
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const outputWidth = getOutputWidth(outputIndex, prev);
            const newWidth = typeof newWidthAction === "function" ? newWidthAction(outputWidth === null || outputWidth === void 0 ? void 0 : outputWidth.width) : newWidthAction;
            if (newWidth && outputWidth) {
                const minSize = outputWidth.index + 1;
                const newValues = [...prev];
                newValues.push(...Array(Math.max(0, minSize - newValues.length)).fill(DECISION_TABLE_OUTPUT_MIN_WIDTH));
                newValues.splice(outputWidth.index, 1, newWidth);
                newMap.set(id, newValues);
            }
        });
    }, [id, getOutputWidth, setWidthsById]);
    const setAnnotationColumnWidth = useCallback((annotationIndex) => (newWidthAction) => {
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const annotationWidth = getAnnotationWidth(annotationIndex, prev);
            const newWidth = typeof newWidthAction === "function" ? newWidthAction(annotationWidth === null || annotationWidth === void 0 ? void 0 : annotationWidth.width) : newWidthAction;
            if (newWidth && annotationWidth) {
                const minSize = annotationWidth.index + 1;
                const newValues = [...prev];
                newValues.push(...Array(Math.max(0, minSize - newValues.length)).fill(DECISION_TABLE_ANNOTATION_MIN_WIDTH));
                newValues.splice(annotationWidth.index, 1, newWidth);
                newMap.set(id, newValues);
            }
        });
    }, [id, getAnnotationWidth, setWidthsById]);
    const columns = useMemo(() => {
        var _a, _b, _c;
        return [
            ...((_a = decisionTableExpression.input) !== null && _a !== void 0 ? _a : []).map((value, index) => {
                var _a, _b;
                return ({
                    ...value,
                    minWidth: DECISION_TABLE_INPUT_MIN_WIDTH,
                    width: (_a = getInputWidth(index, widths)) === null || _a === void 0 ? void 0 : _a.width,
                    label: (_b = value.inputExpression.text) === null || _b === void 0 ? void 0 : _b.__$$text,
                });
            }),
            ...((_b = decisionTableExpression.output) !== null && _b !== void 0 ? _b : []).map((value, index) => {
                var _a;
                return ({
                    ...value,
                    minWidth: DECISION_TABLE_OUTPUT_MIN_WIDTH,
                    width: (_a = getOutputWidth(index, widths)) === null || _a === void 0 ? void 0 : _a.width,
                    label: value["@_name"],
                });
            }),
            ...((_c = decisionTableExpression.annotation) !== null && _c !== void 0 ? _c : []).map((value, index) => {
                var _a;
                return ({
                    ...value,
                    minWidth: DECISION_TABLE_ANNOTATION_MIN_WIDTH,
                    width: (_a = getAnnotationWidth(index, widths)) === null || _a === void 0 ? void 0 : _a.width,
                    label: value["@_name"],
                });
            }),
        ];
    }, [
        decisionTableExpression.annotation,
        decisionTableExpression.input,
        decisionTableExpression.output,
        getAnnotationWidth,
        getInputWidth,
        getOutputWidth,
        widths,
    ]);
    const rules = useMemo(() => {
        var _a;
        return (_a = decisionTableExpression.rule) !== null && _a !== void 0 ? _a : [];
    }, [decisionTableExpression]);
    const beeTableRef = useRef(null);
    const { onColumnResizingWidthChange, columnResizingWidths, isPivoting } = usePublishedBeeTableResizableColumns(decisionTableExpression["@_id"], columns.length, true);
    const lastColumnMinWidth = useNestedTableLastColumnMinWidth(columnResizingWidths);
    useApportionedColumnWidthsIfNestedTable(beeTableRef, isPivoting, isNested, BEE_TABLE_ROW_INDEX_COLUMN_WIDTH, columns, columnResizingWidths, rules);
    const beeTableColumns = useMemo(() => {
        var _a, _b, _c, _d, _e;
        const inputColumns = ((_a = decisionTableExpression.input) !== null && _a !== void 0 ? _a : []).map((inputClause, inputIndex) => {
            var _a, _b, _c, _d, _e, _f;
            return ({
                accessor: (_a = inputClause["@_id"]) !== null && _a !== void 0 ? _a : generateUuid(),
                label: (_c = (_b = inputClause.inputExpression.text) === null || _b === void 0 ? void 0 : _b.__$$text) !== null && _c !== void 0 ? _c : "",
                id: inputClause["@_id"],
                dataType: (_d = inputClause.inputExpression["@_typeRef"]) !== null && _d !== void 0 ? _d : DmnBuiltInDataType.Undefined,
                width: (_f = (_e = getInputWidth(inputIndex, widths)) === null || _e === void 0 ? void 0 : _e.width) !== null && _f !== void 0 ? _f : DECISION_TABLE_INPUT_MIN_WIDTH,
                setWidth: setInputColumnWidth(inputIndex),
                minWidth: DECISION_TABLE_INPUT_MIN_WIDTH,
                groupType: DecisionTableColumnType.InputClause,
                isRowIndexColumn: false,
                isHeaderAFeelExpression: true,
            });
        });
        const outputColumns = ((_b = decisionTableExpression.output) !== null && _b !== void 0 ? _b : []).map((outputClause, outputIndex) => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
            return ({
                accessor: (_a = outputClause["@_id"]) !== null && _a !== void 0 ? _a : generateUuid(),
                id: outputClause["@_id"],
                label: ((_b = decisionTableExpression.output) === null || _b === void 0 ? void 0 : _b.length) == 1
                    ? (_c = decisionTableExpression["@_label"]) !== null && _c !== void 0 ? _c : DEFAULT_EXPRESSION_VARIABLE_NAME
                    : (_e = (_d = outputClause["@_name"]) !== null && _d !== void 0 ? _d : outputClause["@_label"]) !== null && _e !== void 0 ? _e : DEFAULT_EXPRESSION_VARIABLE_NAME,
                dataType: ((_f = decisionTableExpression.output) === null || _f === void 0 ? void 0 : _f.length) == 1
                    ? (_g = decisionTableExpression["@_typeRef"]) !== null && _g !== void 0 ? _g : DmnBuiltInDataType.Undefined
                    : (_h = outputClause["@_typeRef"]) !== null && _h !== void 0 ? _h : DmnBuiltInDataType.Undefined,
                width: (_k = (_j = getOutputWidth(outputIndex, widths)) === null || _j === void 0 ? void 0 : _j.width) !== null && _k !== void 0 ? _k : DECISION_TABLE_OUTPUT_MIN_WIDTH,
                setWidth: setOutputColumnWidth(outputIndex),
                minWidth: DECISION_TABLE_OUTPUT_MIN_WIDTH,
                groupType: DecisionTableColumnType.OutputClause,
                isRowIndexColumn: false,
            });
        });
        const outputGroup = {
            groupType: DecisionTableColumnType.OutputClause,
            id: expressionHolderId,
            accessor: "decision-table-expression",
            label: (_c = decisionTableExpression["@_label"]) !== null && _c !== void 0 ? _c : DEFAULT_EXPRESSION_VARIABLE_NAME,
            dataType: (_d = decisionTableExpression["@_typeRef"]) !== null && _d !== void 0 ? _d : DmnBuiltInDataType.Undefined,
            isRowIndexColumn: false,
            width: undefined,
            columns: outputColumns,
        };
        const annotationColumns = ((_e = decisionTableExpression.annotation) !== null && _e !== void 0 ? _e : []).map((annotation, annotationIndex) => {
            var _a, _b, _c;
            const annotationId = generateUuid();
            return {
                accessor: annotationId,
                id: annotationId,
                label: (_a = annotation["@_name"]) !== null && _a !== void 0 ? _a : "",
                width: (_c = (_b = getAnnotationWidth(annotationIndex, widths)) === null || _b === void 0 ? void 0 : _b.width) !== null && _c !== void 0 ? _c : DECISION_TABLE_ANNOTATION_MIN_WIDTH,
                setWidth: setAnnotationColumnWidth(annotationIndex),
                minWidth: DECISION_TABLE_ANNOTATION_MIN_WIDTH,
                isInlineEditable: true,
                groupType: DecisionTableColumnType.Annotation,
                isRowIndexColumn: false,
                dataType: undefined,
            };
        });
        if (outputColumns.length == 1) {
            return [...inputColumns, ...outputColumns, ...annotationColumns];
        }
        else {
            return [...inputColumns, outputGroup, ...annotationColumns];
        }
    }, [
        expressionHolderId,
        decisionTableExpression,
        getAnnotationWidth,
        getInputWidth,
        getOutputWidth,
        setAnnotationColumnWidth,
        setInputColumnWidth,
        setOutputColumnWidth,
        widths,
    ]);
    const beeTableRows = useMemo(() => {
        const mapRuleToRow = (rule) => {
            var _a, _b, _c;
            const ruleRow = [
                ...((_a = rule.inputEntry) !== null && _a !== void 0 ? _a : []),
                ...((_b = rule.outputEntry) !== null && _b !== void 0 ? _b : new Array(decisionTableExpression.output.length)),
                ...((_c = rule.annotationEntry) !== null && _c !== void 0 ? _c : []),
            ];
            return getColumnsAtLastLevel(beeTableColumns).reduce((tableRow, column, columnIndex) => {
                var _a, _b, _c, _d, _e;
                tableRow[column.accessor] = {
                    id: (_b = (_a = ruleRow[columnIndex]) === null || _a === void 0 ? void 0 : _a["@_id"]) !== null && _b !== void 0 ? _b : "",
                    content: (_e = (_d = (_c = ruleRow[columnIndex]) === null || _c === void 0 ? void 0 : _c.text) === null || _d === void 0 ? void 0 : _d.__$$text) !== null && _e !== void 0 ? _e : "",
                };
                return tableRow;
            }, { id: rule["@_id"] });
        };
        if (!decisionTableExpression.rule || decisionTableExpression.rule.length === 0) {
            return [mapRuleToRow(createDefaultRule())];
        }
        return decisionTableExpression.rule.map(mapRuleToRow);
    }, [decisionTableExpression.rule, decisionTableExpression.output.length, beeTableColumns]);
    const onCellUpdates = useCallback((cellUpdates) => {
        setExpression({
            setExpressionAction: (prev) => {
                let previousExpression = { ...prev };
                if (!previousExpression.rule || previousExpression.rule.length === 0) {
                    previousExpression.rule = [createDefaultRule()];
                }
                cellUpdates.forEach((cellUpdate) => {
                    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
                    const newRules = [...((_a = previousExpression.rule) !== null && _a !== void 0 ? _a : [])];
                    const groupType = cellUpdate.column.groupType;
                    switch (groupType) {
                        case DecisionTableColumnType.InputClause:
                            const newInputEntries = [...((_b = newRules[cellUpdate.rowIndex].inputEntry) !== null && _b !== void 0 ? _b : [])];
                            newInputEntries[cellUpdate.columnIndex] = {
                                ...newInputEntries[cellUpdate.columnIndex],
                                text: {
                                    __$$text: cellUpdate.value,
                                },
                            };
                            newRules[cellUpdate.rowIndex] = {
                                ...newRules[cellUpdate.rowIndex],
                                inputEntry: newInputEntries,
                            };
                            break;
                        case DecisionTableColumnType.OutputClause:
                            const newOutputEntries = [...newRules[cellUpdate.rowIndex].outputEntry];
                            const entryIndex = cellUpdate.columnIndex - ((_d = (_c = prev.input) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0);
                            newOutputEntries[entryIndex] = {
                                ...newOutputEntries[entryIndex],
                                text: {
                                    __$$text: cellUpdate.value,
                                },
                            };
                            newRules[cellUpdate.rowIndex] = {
                                ...newRules[cellUpdate.rowIndex],
                                outputEntry: newOutputEntries,
                            };
                            break;
                        case DecisionTableColumnType.Annotation:
                            const newAnnotationEntries = [...((_e = newRules[cellUpdate.rowIndex].annotationEntry) !== null && _e !== void 0 ? _e : [])];
                            const annotationIndex = cellUpdate.columnIndex - ((_g = (_f = prev.input) === null || _f === void 0 ? void 0 : _f.length) !== null && _g !== void 0 ? _g : 0) - ((_j = (_h = prev.output) === null || _h === void 0 ? void 0 : _h.length) !== null && _j !== void 0 ? _j : 0);
                            newAnnotationEntries[annotationIndex] = {
                                ...newAnnotationEntries[annotationIndex],
                                text: { __$$text: cellUpdate.value },
                            };
                            newRules[cellUpdate.rowIndex] = {
                                ...newRules[cellUpdate.rowIndex],
                                annotationEntry: newAnnotationEntries,
                            };
                            break;
                        default:
                            assertUnreachable(groupType);
                    }
                    previousExpression = {
                        ...previousExpression,
                        rule: newRules,
                    };
                });
                return previousExpression;
            },
            expressionChangedArgs: { action: Action.DecisionTableCellsUpdated },
        });
    }, [setExpression]);
    const getExpressionChangedArgsFromColumnUpdates = useCallback((columnUpdates) => {
        const updateNodeNameOrType = columnUpdates.filter((columnUpdate) => columnUpdate.column.depth === 0 &&
            columnUpdate.column.groupType === DecisionTableColumnType.OutputClause &&
            (decisionTableExpression["@_label"] !== columnUpdate.name ||
                decisionTableExpression["@_typeRef"] !== columnUpdate.typeRef));
        if (updateNodeNameOrType.length > 1) {
            throw new Error("Unexpected multiple name and/or type changed simultaneously in a Decision Table.");
        }
        if (updateNodeNameOrType.length === 1) {
            const expressionChangedArgs = {
                action: Action.VariableChanged,
                variableUuid: isNested ? decisionTableExpression["@_id"] : expressionHolderId,
                typeChange: decisionTableExpression["@_typeRef"] !== updateNodeNameOrType[0].typeRef
                    ? {
                        from: decisionTableExpression["@_typeRef"],
                        to: updateNodeNameOrType[0].typeRef,
                    }
                    : undefined,
                nameChange: decisionTableExpression["@_label"] !== updateNodeNameOrType[0].name
                    ? {
                        from: decisionTableExpression["@_label"],
                        to: updateNodeNameOrType[0].name,
                    }
                    : undefined,
            };
            return expressionChangedArgs;
        }
        else {
            const expressionChangedArgs = { action: Action.ColumnChanged };
            return expressionChangedArgs;
        }
    }, [decisionTableExpression, expressionHolderId, isNested]);
    const onColumnUpdates = useCallback((columnUpdates) => {
        const expressionChangedArgs = getExpressionChangedArgsFromColumnUpdates(columnUpdates);
        setExpression({
            setExpressionAction: (prev) => {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
                const ret = { ...prev };
                for (const columnUpdate of columnUpdates) {
                    if (columnUpdate.column.depth === 0 &&
                        columnUpdate.column.groupType === DecisionTableColumnType.OutputClause) {
                        ret["@_label"] = columnUpdate.name;
                        ret["@_typeRef"] = columnUpdate.typeRef;
                        if (((_a = ret.output) === null || _a === void 0 ? void 0 : _a.length) === 1) {
                            const newOutputs = [...((_b = ret.output) !== null && _b !== void 0 ? _b : [])];
                            newOutputs[0] = {
                                ...newOutputs[0],
                                "@_typeRef": columnUpdate.typeRef,
                                "@_name": columnUpdate.name,
                            };
                        }
                        continue;
                    }
                    const groupType = columnUpdate.column.groupType;
                    switch (groupType) {
                        case DecisionTableColumnType.InputClause:
                            const newInputs = [...((_c = ret.input) !== null && _c !== void 0 ? _c : [])];
                            newInputs[columnUpdate.columnIndex] = {
                                ...newInputs[columnUpdate.columnIndex],
                                inputExpression: {
                                    ...newInputs[columnUpdate.columnIndex].inputExpression,
                                    "@_typeRef": columnUpdate.typeRef,
                                    text: { __$$text: columnUpdate.name },
                                },
                            };
                            ret.input = newInputs;
                            break;
                        case DecisionTableColumnType.OutputClause:
                            const newOutputs = [...((_d = ret.output) !== null && _d !== void 0 ? _d : [])];
                            const outputIndex = columnUpdate.columnIndex - ((_f = (_e = prev.input) === null || _e === void 0 ? void 0 : _e.length) !== null && _f !== void 0 ? _f : 0);
                            newOutputs[outputIndex] = {
                                ...newOutputs[outputIndex],
                                "@_typeRef": columnUpdate.typeRef,
                                "@_name": columnUpdate.name,
                            };
                            ret.output = newOutputs;
                            break;
                        case DecisionTableColumnType.Annotation:
                            const newAnnotations = [...((_g = ret.annotation) !== null && _g !== void 0 ? _g : [])];
                            const annotationIndex = columnUpdate.columnIndex - ((_j = (_h = prev.input) === null || _h === void 0 ? void 0 : _h.length) !== null && _j !== void 0 ? _j : 0) - ((_l = (_k = prev.output) === null || _k === void 0 ? void 0 : _k.length) !== null && _l !== void 0 ? _l : 0);
                            newAnnotations[annotationIndex] = {
                                ...newAnnotations[annotationIndex],
                                "@_name": columnUpdate.name,
                            };
                            ret.annotation = newAnnotations;
                            break;
                        default:
                            assertUnreachable(groupType);
                    }
                }
                return ret;
            },
            expressionChangedArgs,
        });
    }, [getExpressionChangedArgsFromColumnUpdates, setExpression]);
    const onHitPolicySelect = useCallback((hitPolicy) => {
        setExpression({
            setExpressionAction: (prev) => {
                const ret = {
                    ...prev,
                    "@_hitPolicy": hitPolicy,
                    "@_aggregation": HIT_POLICIES_THAT_SUPPORT_AGGREGATION.includes(hitPolicy)
                        ? prev["@_aggregation"]
                        : undefined,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.DecisionTableHitPolicyChanged },
        });
    }, [setExpression]);
    const getAggregation = useCallback((aggKey) => {
        switch (aggKey) {
            case "<":
                return "MIN";
            case ">":
                return "MAX";
            case "#":
                return "COUNT";
            case "+":
                return "SUM";
            case "?":
                return undefined;
        }
    }, []);
    const getAggregationKey = useCallback((aggKey) => {
        if (!aggKey) {
            return "?";
        }
        switch (aggKey) {
            case "MIN":
                return "<";
            case "MAX":
                return ">";
            case "COUNT":
                return "#";
            case "SUM":
                return "+";
            default:
                return "?";
        }
    }, []);
    const onBuiltInAggregatorSelect = useCallback((aggregation) => {
        setExpression({
            setExpressionAction: (prev) => {
                const ret = {
                    ...prev,
                    "@_aggregation": getAggregation(aggregation),
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.DecisionTableBuiltInAggregatorChanged },
        });
    }, [getAggregation, setExpression]);
    const controllerCell = useMemo(() => {
        var _a;
        return (_jsx(HitPolicySelector, { selectedHitPolicy: (_a = decisionTableExpression["@_hitPolicy"]) !== null && _a !== void 0 ? _a : "UNIQUE", selectedBuiltInAggregator: getAggregationKey(decisionTableExpression["@_aggregation"]), onHitPolicySelected: onHitPolicySelect, onBuiltInAggregatorSelected: onBuiltInAggregatorSelect, isReadOnly: isReadOnly !== null && isReadOnly !== void 0 ? isReadOnly : false }));
    }, [decisionTableExpression, getAggregationKey, isReadOnly, onBuiltInAggregatorSelect, onHitPolicySelect]);
    const onRowAdded = useCallback((args) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a, _b, _c, _d, _e, _f, _g;
                let newRules = [...((_a = prev.rule) !== null && _a !== void 0 ? _a : [])];
                if (newRules.length === 0) {
                    newRules = [createDefaultRule()];
                }
                const newItems = [];
                for (let i = 0; i < args.rowsCount; i++) {
                    newItems.push({
                        "@_id": generateUuid(),
                        inputEntry: Array.from(new Array((_c = (_b = prev.input) === null || _b === void 0 ? void 0 : _b.length) !== null && _c !== void 0 ? _c : 0)).map(() => {
                            return createInputEntry();
                        }),
                        outputEntry: Array.from(new Array((_e = (_d = prev.output) === null || _d === void 0 ? void 0 : _d.length) !== null && _e !== void 0 ? _e : 0)).map(() => {
                            return createOutputEntry();
                        }),
                        annotationEntry: Array.from(new Array((_g = (_f = prev.annotation) === null || _f === void 0 ? void 0 : _f.length) !== null && _g !== void 0 ? _g : 0)).map(() => {
                            return { text: { __$$text: DECISION_TABLE_ANNOTATION_DEFAULT_VALUE } };
                        }),
                    });
                }
                for (const newEntry of newItems) {
                    newRules.splice(args.beforeIndex, 0, newEntry);
                }
                const ret = {
                    ...prev,
                    rule: newRules,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.RowsAdded, rowIndex: args.beforeIndex, rowsCount: args.rowsCount },
        });
    }, [setExpression]);
    const getLocalIndexInsideGroupType = useCallback((columnIndex, groupType) => {
        var _a, _b, _c, _d, _e, _f;
        switch (groupType) {
            case DecisionTableColumnType.InputClause:
                return columnIndex;
            case DecisionTableColumnType.OutputClause:
                return columnIndex - ((_b = (_a = decisionTableExpression.input) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0);
            case DecisionTableColumnType.Annotation:
                return (columnIndex - ((_d = (_c = decisionTableExpression.input) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0) - ((_f = (_e = decisionTableExpression.output) === null || _e === void 0 ? void 0 : _e.length) !== null && _f !== void 0 ? _f : 0));
            default:
                assertUnreachable(groupType);
        }
    }, [(_d = decisionTableExpression.input) === null || _d === void 0 ? void 0 : _d.length, (_e = decisionTableExpression.output) === null || _e === void 0 ? void 0 : _e.length]);
    const onColumnAdded = useCallback((args) => {
        const groupType = args.groupType;
        if (!groupType) {
            throw new Error("Column without groupType for Decision table.");
        }
        const localIndexInsideGroup = getLocalIndexInsideGroupType(args.beforeIndex, groupType);
        setExpression({
            setExpressionAction: (prev) => {
                var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
                const nextRows = [...((_a = prev.rule) !== null && _a !== void 0 ? _a : [])];
                switch (groupType) {
                    case DecisionTableColumnType.InputClause:
                        const inputColumnsToAdd = [];
                        const currentInputNames = (_c = (_b = prev.input) === null || _b === void 0 ? void 0 : _b.map((c) => { var _a, _b; return (_b = (_a = c.inputExpression.text) === null || _a === void 0 ? void 0 : _a.__$$text) !== null && _b !== void 0 ? _b : ""; })) !== null && _c !== void 0 ? _c : [];
                        for (let i = 0; i < args.columnsCount; i++) {
                            const newName = getNextAvailablePrefixedName(currentInputNames, "Input");
                            currentInputNames.push(newName);
                            inputColumnsToAdd.push({
                                "@_id": generateUuid(),
                                inputExpression: {
                                    "@_id": generateUuid(),
                                    "@_typeRef": undefined,
                                    text: { __$$text: newName },
                                },
                            });
                        }
                        const nextInputColumns = [...((_d = prev.input) !== null && _d !== void 0 ? _d : [])];
                        for (let i = 0; i < inputColumnsToAdd.length; i++) {
                            nextInputColumns.splice(localIndexInsideGroup + i, 0, inputColumnsToAdd[i]);
                        }
                        for (let i = 0; i < nextRows.length; i++) {
                            const row = nextRows[i];
                            const nextInputEntries = [...((_e = row.inputEntry) !== null && _e !== void 0 ? _e : [])];
                            for (let j = 0; j < args.columnsCount; j++) {
                                nextInputEntries.splice(localIndexInsideGroup + j, 0, createInputEntry());
                            }
                            nextRows[i] = { ...row, inputEntry: nextInputEntries };
                        }
                        const retInput = {
                            ...prev,
                            input: nextInputColumns,
                            rule: nextRows,
                        };
                        return retInput;
                    case DecisionTableColumnType.OutputClause:
                        const outputColumnsToAdd = [];
                        const currentOutputColumnNames = (_g = (_f = prev.output) === null || _f === void 0 ? void 0 : _f.map((c) => { var _a; return (_a = c["@_name"]) !== null && _a !== void 0 ? _a : ""; })) !== null && _g !== void 0 ? _g : [];
                        for (let i = 0; i < args.columnsCount; i++) {
                            const name = getNextAvailablePrefixedName(currentOutputColumnNames, "Output");
                            currentOutputColumnNames.push(name);
                            outputColumnsToAdd.push({
                                "@_id": generateUuid(),
                                "@_name": name,
                                "@_typeRef": undefined,
                            });
                        }
                        const nextOutputColumns = [
                            ...((_h = prev.output) !== null && _h !== void 0 ? _h : []).map((outputColumn, index) => {
                                const outputCopy = { ...outputColumn };
                                if (outputCopy["@_name"] === undefined) {
                                    outputCopy["@_name"] = `Output-${index + 1}`;
                                }
                                return outputCopy;
                            }),
                        ];
                        for (let i = 0; i < outputColumnsToAdd.length; i++) {
                            nextOutputColumns.splice(localIndexInsideGroup + i, 0, outputColumnsToAdd[i]);
                        }
                        for (let i = 0; i < nextRows.length; i++) {
                            const row = nextRows[i];
                            const nextOutputEntries = [...((_j = row.outputEntry) !== null && _j !== void 0 ? _j : [])];
                            for (let j = 0; j < args.columnsCount; j++) {
                                nextOutputEntries.splice(localIndexInsideGroup + j, 0, createOutputEntry());
                            }
                            nextRows[i] = { ...row, outputEntry: nextOutputEntries };
                        }
                        const retOutput = {
                            ...prev,
                            output: nextOutputColumns,
                            rule: nextRows,
                        };
                        return retOutput;
                    case DecisionTableColumnType.Annotation:
                        const annotationColumnsToAdd = [];
                        const currentAnnotationColumnNames = (_l = (_k = prev.annotation) === null || _k === void 0 ? void 0 : _k.map((c) => { var _a; return (_a = c["@_name"]) !== null && _a !== void 0 ? _a : ""; })) !== null && _l !== void 0 ? _l : [];
                        for (let i = 0; i < args.columnsCount; i++) {
                            const newName = getNextAvailablePrefixedName(currentAnnotationColumnNames, "Annotations");
                            currentAnnotationColumnNames.push(newName);
                            annotationColumnsToAdd.push({ "@_name": newName });
                        }
                        const nextAnnotationColumns = [...((_m = prev.annotation) !== null && _m !== void 0 ? _m : [])];
                        for (let i = 0; i < annotationColumnsToAdd.length; i++) {
                            nextAnnotationColumns.splice(localIndexInsideGroup + i, 0, annotationColumnsToAdd[i]);
                        }
                        for (let i = 0; i < nextRows.length; i++) {
                            const row = nextRows[i];
                            const nextAnnotationEntries = [...((_o = row.annotationEntry) !== null && _o !== void 0 ? _o : [])];
                            for (let j = 0; j < args.columnsCount; j++) {
                                nextAnnotationEntries.splice(localIndexInsideGroup + j, 0, createAnnotationEntry());
                            }
                            nextRows[i] = { ...row, annotationEntry: nextAnnotationEntries };
                        }
                        const retAnnotation = {
                            ...prev,
                            annotation: nextAnnotationColumns,
                            rule: nextRows,
                        };
                        return retAnnotation;
                    default:
                        assertUnreachable(groupType);
                }
            },
            expressionChangedArgs: {
                action: Action.ColumnAdded,
                columnIndex: args.beforeIndex,
                columnCount: args.columnsCount,
            },
        });
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const defaultWidth = args.groupType === DecisionTableColumnType.InputClause
                ? DECISION_TABLE_INPUT_DEFAULT_WIDTH
                : args.groupType === DecisionTableColumnType.OutputClause
                    ? DECISION_TABLE_OUTPUT_DEFAULT_WIDTH
                    : DECISION_TABLE_ANNOTATION_DEFAULT_WIDTH;
            const nextValues = [...prev];
            const minValuesLength = args.beforeIndex + args.columnsCount;
            nextValues.push(...Array(Math.max(0, minValuesLength - nextValues.length)));
            for (let i = 0; i < args.columnsCount; i++) {
                const widthIndex = args.beforeIndex + i + 1;
                nextValues.splice(widthIndex, 0, defaultWidth);
            }
            newMap.set(id, nextValues);
        });
    }, [getLocalIndexInsideGroupType, setExpression, setWidthsById, id]);
    const onColumnDeleted = useCallback((args) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a, _b, _c, _d, _e, _f;
                const groupType = args.groupType;
                if (!groupType) {
                    throw new Error("Column without groupType for Decision table.");
                }
                const localIndexInsideGroup = getLocalIndexInsideGroupType(args.columnIndex, groupType);
                switch (groupType) {
                    case DecisionTableColumnType.InputClause:
                        const newInputs = [...((_a = prev.input) !== null && _a !== void 0 ? _a : [])];
                        newInputs.splice(localIndexInsideGroup, 1);
                        const retInput = {
                            ...prev,
                            input: newInputs,
                            rule: [...((_b = prev.rule) !== null && _b !== void 0 ? _b : [])].map((rule) => {
                                var _a;
                                const newInputEntry = [...((_a = rule.inputEntry) !== null && _a !== void 0 ? _a : [])];
                                newInputEntry.splice(localIndexInsideGroup, 1);
                                return {
                                    ...rule,
                                    inputEntry: newInputEntry,
                                };
                            }),
                        };
                        return retInput;
                    case DecisionTableColumnType.OutputClause:
                        const newOutputs = [...((_c = prev.output) !== null && _c !== void 0 ? _c : [])];
                        newOutputs.splice(localIndexInsideGroup, 1);
                        const updatedOutputForSingleOutputColumns = [
                            ...(newOutputs !== null && newOutputs !== void 0 ? newOutputs : []).map((outputColumn) => {
                                const outputCopy = { ...outputColumn };
                                if (newOutputs.length === 1) {
                                    outputCopy["@_name"] = undefined;
                                    outputCopy["@_typeRef"] = undefined;
                                }
                                return outputCopy;
                            }),
                        ];
                        const retOutput = {
                            ...prev,
                            output: updatedOutputForSingleOutputColumns,
                            rule: [...((_d = prev.rule) !== null && _d !== void 0 ? _d : [])].map((rule) => {
                                const newOutputEntry = [...rule.outputEntry];
                                newOutputEntry.splice(localIndexInsideGroup, 1);
                                return {
                                    ...rule,
                                    outputEntry: newOutputEntry,
                                };
                            }),
                        };
                        return retOutput;
                    case DecisionTableColumnType.Annotation:
                        const newAnnotations = [...((_e = prev.annotation) !== null && _e !== void 0 ? _e : [])];
                        newAnnotations.splice(localIndexInsideGroup, 1);
                        const retAnnotation = {
                            ...prev,
                            annotation: newAnnotations,
                            rule: [...((_f = prev.rule) !== null && _f !== void 0 ? _f : [])].map((rule) => {
                                var _a;
                                const newAnnotationEntry = [...((_a = rule.annotationEntry) !== null && _a !== void 0 ? _a : [])];
                                newAnnotationEntry.splice(localIndexInsideGroup, 1);
                                return {
                                    ...rule,
                                    annotationEntry: newAnnotationEntry,
                                };
                            }),
                        };
                        return retAnnotation;
                    default:
                        assertUnreachable(groupType);
                }
            },
            expressionChangedArgs: { action: Action.ColumnRemoved, columnIndex: args.columnIndex },
        });
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const newValues = [...prev];
            newValues.splice(args.columnIndex + 1, 1);
            newMap.set(id, newValues);
        });
    }, [getLocalIndexInsideGroupType, id, setExpression, setWidthsById]);
    const onRowDeleted = useCallback((args) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const newRules = [...((_a = prev.rule) !== null && _a !== void 0 ? _a : [])];
                newRules.splice(args.rowIndex, 1);
                const ret = {
                    ...prev,
                    rule: newRules,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.RowRemoved, rowIndex: args.rowIndex },
        });
    }, [setExpression]);
    const onRowDuplicated = useCallback((args) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a, _b, _c;
                const duplicatedRule = {
                    "@_id": generateUuid(),
                    inputEntry: (_a = prev.rule[args.rowIndex].inputEntry) === null || _a === void 0 ? void 0 : _a.map((input) => ({
                        ...input,
                        "@_id": generateUuid(),
                    })),
                    outputEntry: prev.rule[args.rowIndex].outputEntry.map((output) => ({
                        ...output,
                        "@_id": generateUuid(),
                    })),
                    annotationEntry: (_b = prev.rule[args.rowIndex].annotationEntry) === null || _b === void 0 ? void 0 : _b.slice(),
                };
                const newRules = [...((_c = prev.rule) !== null && _c !== void 0 ? _c : [])];
                newRules.splice(args.rowIndex, 0, duplicatedRule);
                const ret = {
                    ...prev,
                    rule: newRules,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.RowDuplicated, rowIndex: args.rowIndex },
        });
    }, [setExpression]);
    const beeTableHeaderVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.LastLevel : BeeTableHeaderVisibility.AllLevels;
    }, [isNested]);
    const allowedOperations = useCallback((conditions) => {
        var _a, _b, _c, _d, _e, _f;
        if (!conditions.selection.selectionStart || !conditions.selection.selectionEnd) {
            return [];
        }
        const columnIndex = conditions.selection.selectionStart.columnIndex;
        const atLeastTwoColumnsOfTheSameGroupType = ((_a = conditions.column) === null || _a === void 0 ? void 0 : _a.groupType)
            ? _.groupBy(conditions.columns, (column) => column === null || column === void 0 ? void 0 : column.groupType)[conditions.column.groupType].length > 1
            : true;
        const columnCanBeDeleted = columnIndex > 0 &&
            atLeastTwoColumnsOfTheSameGroupType &&
            ((_c = (_b = conditions.columns) === null || _b === void 0 ? void 0 : _b.length) !== null && _c !== void 0 ? _c : 0) > 2 &&
            ((_f = (_e = (_d = conditions.column) === null || _d === void 0 ? void 0 : _d.columns) === null || _e === void 0 ? void 0 : _e.length) !== null && _f !== void 0 ? _f : 0) <= 0;
        const columnOperations = columnIndex === 0
            ? []
            : [
                BeeTableOperation.ColumnInsertLeft,
                BeeTableOperation.ColumnInsertRight,
                BeeTableOperation.ColumnInsertN,
                ...(columnCanBeDeleted ? [BeeTableOperation.ColumnDelete] : []),
            ];
        return [
            ...columnOperations,
            BeeTableOperation.SelectionCopy,
            ...(conditions.selection.selectionStart.rowIndex >= 0 && columnIndex > 0
                ? [BeeTableOperation.SelectionCut, BeeTableOperation.SelectionPaste, BeeTableOperation.SelectionReset]
                : []),
            ...(conditions.selection.selectionStart.rowIndex >= 0
                ? [
                    BeeTableOperation.RowInsertAbove,
                    BeeTableOperation.RowInsertBelow,
                    BeeTableOperation.RowInsertN,
                    ...(beeTableRows.length > 1 ? [BeeTableOperation.RowDelete] : []),
                    BeeTableOperation.RowReset,
                    BeeTableOperation.RowDuplicate,
                ]
                : []),
        ];
    }, [beeTableRows.length]);
    const supportsEvaluationHitsCount = useCallback((row) => {
        return true;
    }, []);
    return (_jsx("div", { className: `decision-table-expression ${decisionTableExpression["@_id"]}`, children: _jsx(BeeTable, { isReadOnly: isReadOnly, isEditableHeader: !isReadOnly, resizerStopBehavior: isPivoting ? ResizerStopBehavior.SET_WIDTH_ALWAYS : ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, forwardRef: beeTableRef, headerLevelCountForAppendingRowIndexColumn: 1, headerVisibility: beeTableHeaderVisibility, editColumnLabel: getEditColumnLabel, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, columns: beeTableColumns, rows: beeTableRows, onColumnUpdates: onColumnUpdates, onCellUpdates: onCellUpdates, controllerCell: controllerCell, onRowAdded: onRowAdded, onRowDeleted: onRowDeleted, onRowDuplicated: onRowDuplicated, onColumnAdded: onColumnAdded, onColumnDeleted: onColumnDeleted, onColumnResizingWidthChange: onColumnResizingWidthChange, shouldRenderRowIndexColumn: true, shouldShowRowsInlineControls: true, shouldShowColumnsInlineControls: true, supportsEvaluationHitsCount: supportsEvaluationHitsCount }) }));
}
//# sourceMappingURL=DecisionTableExpression.js.map