import { DmnBuiltInDataType } from "../api";
import { DEFAULT_MIN_WIDTH } from "./WidthConstants";
const canvas = document.createElement("canvas");
export function getTextWidth(text, font) {
    const context = canvas.getContext("2d");
    context.font = font;
    const metrics = context.measureText(text);
    return Math.ceil(metrics.width);
}
function getCssStyle(element, prop) {
    return window.getComputedStyle(element, null).getPropertyValue(prop);
}
export function getCanvasFont(el) {
    const fontWeight = getCssStyle(el, "font-weight") || "normal";
    const fontSize = getCssStyle(el, "font-size") || "16px";
    const fontFamily = getCssStyle(el, "font-family") || "Times New Roman";
    return `${fontWeight} ${fontSize} ${fontFamily}`;
}
export function getDefaultColumnWidth({ name, typeRef }) {
    return (8 * 2 +
        2 +
        Math.max(DEFAULT_MIN_WIDTH, getTextWidth(name, "700 11.2px Menlo, monospace"), getTextWidth(`(${typeRef !== null && typeRef !== void 0 ? typeRef : DmnBuiltInDataType.Undefined})`, "700 11.6667px RedHatText, Overpass, overpass, helvetica, arial, sans-serif")));
}
//# sourceMappingURL=WidthsToFitData.js.map