import { useMemo } from "react";
import * as RF from "reactflow";
import { useDmnEditorStore } from "../../store/StoreContext";
import { getSnappedMultiPointAnchoredEdgePath } from "./getSnappedMultiPointAnchoredEdgePath";
export function useKieEdgePath(source, target, data) {
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const sourceNodeX = RF.useStore((s) => { var _a, _b; return (source ? (_b = (_a = s.nodeInternals.get(source)) === null || _a === void 0 ? void 0 : _a.positionAbsolute) === null || _b === void 0 ? void 0 : _b.x : undefined); });
    const sourceNodeY = RF.useStore((s) => { var _a, _b; return (source ? (_b = (_a = s.nodeInternals.get(source)) === null || _a === void 0 ? void 0 : _a.positionAbsolute) === null || _b === void 0 ? void 0 : _b.y : undefined); });
    const sourceNodeWidth = RF.useStore((s) => { var _a; return (source ? (_a = s.nodeInternals.get(source)) === null || _a === void 0 ? void 0 : _a.width : undefined); });
    const sourceNodeHeight = RF.useStore((s) => { var _a; return (source ? (_a = s.nodeInternals.get(source)) === null || _a === void 0 ? void 0 : _a.height : undefined); });
    const targetNodeX = RF.useStore((s) => { var _a, _b; return (target ? (_b = (_a = s.nodeInternals.get(target)) === null || _a === void 0 ? void 0 : _a.positionAbsolute) === null || _b === void 0 ? void 0 : _b.x : undefined); });
    const targetNodeY = RF.useStore((s) => { var _a, _b; return (target ? (_b = (_a = s.nodeInternals.get(target)) === null || _a === void 0 ? void 0 : _a.positionAbsolute) === null || _b === void 0 ? void 0 : _b.y : undefined); });
    const targetNodeWidth = RF.useStore((s) => { var _a; return (target ? (_a = s.nodeInternals.get(target)) === null || _a === void 0 ? void 0 : _a.width : undefined); });
    const targetNodeHeight = RF.useStore((s) => { var _a; return (target ? (_a = s.nodeInternals.get(target)) === null || _a === void 0 ? void 0 : _a.height : undefined); });
    const dmnEdge = data === null || data === void 0 ? void 0 : data.dmnEdge;
    const dmnShapeSource = data === null || data === void 0 ? void 0 : data.dmnShapeSource;
    const dmnShapeTarget = data === null || data === void 0 ? void 0 : data.dmnShapeTarget;
    return useMemo(() => getSnappedMultiPointAnchoredEdgePath({
        snapGrid,
        dmnEdge,
        sourceNodeBounds: { x: sourceNodeX, y: sourceNodeY, width: sourceNodeWidth, height: sourceNodeHeight },
        targetNodeBounds: { x: targetNodeX, y: targetNodeY, width: targetNodeWidth, height: targetNodeHeight },
        dmnShapeSource,
        dmnShapeTarget,
    }), [
        dmnEdge,
        dmnShapeSource,
        dmnShapeTarget,
        snapGrid,
        sourceNodeHeight,
        sourceNodeWidth,
        sourceNodeX,
        sourceNodeY,
        targetNodeHeight,
        targetNodeWidth,
        targetNodeX,
        targetNodeY,
    ]);
}
//# sourceMappingURL=useKieEdgePath.js.map