import * as RF from "reactflow";
import { DmnDiagramEdgeData } from "../diagram/edges/Edges";
import { DmnDiagramNodeData } from "../diagram/nodes/Nodes";
import { Computed, SnapGrid, State } from "../store/Store";
import { NodeLabelPosition } from "../diagram/nodes/NodeSvgs";
import { TypeOrReturnType } from "../store/ComputedStateCache";
import { UniqueNameIndex } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { DataTypeIndex } from "../dataTypes/DataTypes";
export declare function DmnDiagramSvg({ nodes, edges, snapGrid, thisDmn, importsByNamespace, isAlternativeInputDataShape, allDataTypesById, allTopLevelItemDefinitionUniqueNames, }: {
    nodes: RF.Node<DmnDiagramNodeData>[];
    edges: RF.Edge<DmnDiagramEdgeData>[];
    snapGrid: SnapGrid;
    thisDmn: State["dmn"];
    importsByNamespace: TypeOrReturnType<Computed["importsByNamespace"]>;
    isAlternativeInputDataShape: boolean;
    allDataTypesById: DataTypeIndex;
    allTopLevelItemDefinitionUniqueNames: UniqueNameIndex;
}): JSX.Element;
export declare function getNodeLabelSvgTextAlignmentProps(n: RF.Node<DmnDiagramNodeData>, labelPosition: NodeLabelPosition): {
    readonly verticalAnchor: "start";
    readonly textAnchor: "middle";
    readonly transform: `translate(${number},${number})`;
    readonly width: number;
} | {
    readonly verticalAnchor: "middle";
    readonly textAnchor: "middle";
    readonly transform: `translate(${number},${number})`;
    readonly width: number;
} | {
    readonly verticalAnchor: "middle";
    readonly textAnchor: "start";
    readonly transform: `translate(${number},${number})`;
    readonly width: number;
} | {
    readonly verticalAnchor: "start";
    readonly textAnchor: "start";
    readonly transform: `translate(${number},${number})`;
    readonly width: number;
};
//# sourceMappingURL=DmnDiagramSvg.d.ts.map