/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.apache.polaris.core.admin.model.CatalogPrivilege;
import org.apache.polaris.core.admin.model.GrantResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CatalogGrant
extends GrantResource {
    @NotNull
    @Valid
    private final CatalogPrivilege privilege;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="privilege", required=true)
    public CatalogPrivilege getPrivilege() {
        return this.privilege;
    }

    @JsonCreator
    public CatalogGrant(@JsonProperty(value="privilege", required=true) CatalogPrivilege privilege, @JsonProperty(value="type", required=true) GrantResource.TypeEnum type) {
        super(type);
        this.privilege = privilege;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CatalogPrivilege privilege, GrantResource.TypeEnum type) {
        return new Builder(privilege, type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogGrant catalogGrant = (CatalogGrant)o;
        return super.equals(o) && Objects.equals((Object)this.privilege, (Object)catalogGrant.privilege);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.privilege});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogGrant {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    privilege: ").append(this.toIndentedString((Object)this.privilege)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private CatalogPrivilege privilege;
        private GrantResource.TypeEnum type;

        private Builder() {
        }

        private Builder(CatalogPrivilege privilege, GrantResource.TypeEnum type) {
            this.privilege = privilege;
            this.type = type;
        }

        public Builder setPrivilege(CatalogPrivilege privilege) {
            this.privilege = privilege;
            return this;
        }

        public Builder setType(GrantResource.TypeEnum type) {
            this.type = type;
            return this;
        }

        public CatalogGrant build() {
            CatalogGrant inst = new CatalogGrant(this.privilege, this.type);
            return inst;
        }
    }
}

