/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.LiveTailSessionLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.LiveTailSessionMetadata;
import software.amazon.awssdk.services.cloudwatchlogs.model.LiveTailSessionResultsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailResponseHandler;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartLiveTailResponseStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LiveTailSessionUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LiveTailSessionUpdate>,
StartLiveTailResponseStream {
    private static final SdkField<LiveTailSessionMetadata> SESSION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionMetadata").getter(LiveTailSessionUpdate.getter(LiveTailSessionUpdate::sessionMetadata)).setter(LiveTailSessionUpdate.setter(Builder::sessionMetadata)).constructor(LiveTailSessionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionMetadata").build()}).build();
    private static final SdkField<List<LiveTailSessionLogEvent>> SESSION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sessionResults").getter(LiveTailSessionUpdate.getter(LiveTailSessionUpdate::sessionResults)).setter(LiveTailSessionUpdate.setter(Builder::sessionResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LiveTailSessionLogEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_METADATA_FIELD, SESSION_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LiveTailSessionUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LiveTailSessionMetadata sessionMetadata;
    private final List<LiveTailSessionLogEvent> sessionResults;

    protected LiveTailSessionUpdate(BuilderImpl builder) {
        this.sessionMetadata = builder.sessionMetadata;
        this.sessionResults = builder.sessionResults;
    }

    public final LiveTailSessionMetadata sessionMetadata() {
        return this.sessionMetadata;
    }

    public final boolean hasSessionResults() {
        return this.sessionResults != null && !(this.sessionResults instanceof SdkAutoConstructList);
    }

    public final List<LiveTailSessionLogEvent> sessionResults() {
        return this.sessionResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionResults() ? this.sessionResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveTailSessionUpdate)) {
            return false;
        }
        LiveTailSessionUpdate other = (LiveTailSessionUpdate)obj;
        return Objects.equals(this.sessionMetadata(), other.sessionMetadata()) && this.hasSessionResults() == other.hasSessionResults() && Objects.equals(this.sessionResults(), other.sessionResults());
    }

    public final String toString() {
        return ToString.builder((String)"LiveTailSessionUpdate").add("SessionMetadata", (Object)this.sessionMetadata()).add("SessionResults", this.hasSessionResults() ? this.sessionResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionMetadata": {
                return Optional.ofNullable(clazz.cast(this.sessionMetadata()));
            }
            case "sessionResults": {
                return Optional.ofNullable(clazz.cast(this.sessionResults()));
            }
        }
        return Optional.empty();
    }

    public final LiveTailSessionUpdate copy(Consumer<? super Builder> modifier) {
        return (LiveTailSessionUpdate)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionMetadata", SESSION_METADATA_FIELD);
        map.put("sessionResults", SESSION_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiveTailSessionUpdate, T> g) {
        return obj -> g.apply((LiveTailSessionUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(StartLiveTailResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private LiveTailSessionMetadata sessionMetadata;
        private List<LiveTailSessionLogEvent> sessionResults = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(LiveTailSessionUpdate model) {
            this.sessionMetadata(model.sessionMetadata);
            this.sessionResults(model.sessionResults);
        }

        public final LiveTailSessionMetadata.Builder getSessionMetadata() {
            return this.sessionMetadata != null ? this.sessionMetadata.toBuilder() : null;
        }

        public final void setSessionMetadata(LiveTailSessionMetadata.BuilderImpl sessionMetadata) {
            this.sessionMetadata = sessionMetadata != null ? sessionMetadata.build() : null;
        }

        @Override
        public final Builder sessionMetadata(LiveTailSessionMetadata sessionMetadata) {
            this.sessionMetadata = sessionMetadata;
            return this;
        }

        public final List<LiveTailSessionLogEvent.Builder> getSessionResults() {
            List<LiveTailSessionLogEvent.Builder> result = LiveTailSessionResultsCopier.copyToBuilder(this.sessionResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionResults(Collection<LiveTailSessionLogEvent.BuilderImpl> sessionResults) {
            this.sessionResults = LiveTailSessionResultsCopier.copyFromBuilder(sessionResults);
        }

        @Override
        public final Builder sessionResults(Collection<LiveTailSessionLogEvent> sessionResults) {
            this.sessionResults = LiveTailSessionResultsCopier.copy(sessionResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionResults(LiveTailSessionLogEvent ... sessionResults) {
            this.sessionResults(Arrays.asList(sessionResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionResults(Consumer<LiveTailSessionLogEvent.Builder> ... sessionResults) {
            this.sessionResults(Stream.of(sessionResults).map(c -> (LiveTailSessionLogEvent)((LiveTailSessionLogEvent.Builder)LiveTailSessionLogEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LiveTailSessionUpdate build() {
            return new LiveTailSessionUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LiveTailSessionUpdate> {
        public Builder sessionMetadata(LiveTailSessionMetadata var1);

        default public Builder sessionMetadata(Consumer<LiveTailSessionMetadata.Builder> sessionMetadata) {
            return this.sessionMetadata((LiveTailSessionMetadata)((LiveTailSessionMetadata.Builder)LiveTailSessionMetadata.builder().applyMutation(sessionMetadata)).build());
        }

        public Builder sessionResults(Collection<LiveTailSessionLogEvent> var1);

        public Builder sessionResults(LiveTailSessionLogEvent ... var1);

        public Builder sessionResults(Consumer<LiveTailSessionLogEvent.Builder> ... var1);
    }
}

