/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure.iterator;

import java.io.IOException;
import org.apache.iotdb.db.queryengine.transformation.datastructure.iterator.ListForwardIterator;
import org.apache.iotdb.db.queryengine.transformation.datastructure.row.ElasticSerializableRowList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.row.SerializableRowList;
import org.apache.tsfile.block.column.Column;

public class RowListForwardIterator
implements ListForwardIterator {
    private final ElasticSerializableRowList rowList;
    private int externalIndex;
    private int internalIndex;
    private int endRowIndex;

    public RowListForwardIterator(ElasticSerializableRowList rowList) {
        this.rowList = rowList;
        this.externalIndex = 0;
        this.internalIndex = -1;
        this.endRowIndex = 0;
    }

    public RowListForwardIterator(ElasticSerializableRowList rowList, int externalIndex, int internalIndex) throws IOException {
        this.rowList = rowList;
        this.externalIndex = externalIndex;
        this.internalIndex = internalIndex;
        this.endRowIndex = rowList.getLastRowIndex(externalIndex, internalIndex);
    }

    public Column[] currentBlock() throws IOException {
        return this.rowList.getColumns(this.externalIndex, this.internalIndex);
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.rowList.getSerializableRowListSize() == 0) {
            return false;
        }
        return this.externalIndex + 1 < this.rowList.getSerializableRowListSize() || this.internalIndex + 1 < this.rowList.getSerializableRowList(this.externalIndex).getBlockCount();
    }

    @Override
    public void next() throws IOException {
        if (this.internalIndex + 1 == this.rowList.getBlockCount(this.externalIndex)) {
            this.internalIndex = 0;
            ++this.externalIndex;
        } else {
            ++this.internalIndex;
        }
        SerializableRowList internalRowList = this.rowList.getSerializableRowList(this.externalIndex);
        this.endRowIndex += internalRowList.getBlockSize(this.internalIndex);
    }

    public void adjust() throws IOException {
        int capacity = this.rowList.getInternalRowListCapacity();
        int externalColumnIndex = this.endRowIndex / capacity;
        int internalRowIndex = this.endRowIndex % capacity;
        int internalColumnIndex = this.rowList.getSerializableRowList(externalColumnIndex).getColumnIndex(internalRowIndex - 1);
        this.externalIndex = externalColumnIndex;
        this.internalIndex = internalColumnIndex;
    }
}

