/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class GuardianStringKeyMultivaluedMap<V>
implements MultivaluedMap<String, V> {
    private final MultivaluedMap<String, V> inner;
    private final Map<String, Boolean> guards = new HashMap<String, Boolean>();

    private static boolean isMutable(Object mutable) {
        return !String.class.isInstance(mutable) && !MediaType.class.isInstance(mutable);
    }

    public GuardianStringKeyMultivaluedMap(MultivaluedMap<String, V> inner) {
        this.inner = inner;
    }

    public void putSingle(String key, V value) {
        this.observe(key);
        this.inner.putSingle((Object)key, value);
    }

    public void add(String key, V value) {
        this.observe(key);
        this.inner.add((Object)key, value);
    }

    public V getFirst(String key) {
        Object first = this.inner.getFirst((Object)key);
        if (GuardianStringKeyMultivaluedMap.isMutable(key)) {
            this.observe(key);
        }
        return (V)first;
    }

    public void addAll(String key, V ... newValues) {
        this.observe(key);
        this.inner.addAll((Object)key, (Object[])newValues);
    }

    public void addAll(String key, List<V> valueList) {
        this.observe(key);
        this.inner.addAll((Object)key, valueList);
    }

    public void addFirst(String key, V value) {
        this.observe(key);
        this.inner.addFirst((Object)key, value);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, V> otherMap) {
        return this.inner.equalsIgnoreValueOrder(otherMap);
    }

    public int size() {
        return this.inner.size();
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.inner.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.inner.containsValue(value);
    }

    public List<V> get(Object key) {
        List innerList = (List)this.inner.get(key);
        if (innerList != null) {
            for (Map.Entry<String, Boolean> guard : this.guards.entrySet()) {
                if (!guard.getKey().equals(key)) continue;
                return new GuardianList(innerList, guard);
            }
        }
        return innerList;
    }

    public List<V> put(String key, List<V> value) {
        this.observe(key);
        return (List)this.inner.put((Object)key, value);
    }

    public List<V> remove(Object key) {
        if (key != null) {
            this.observe(key.toString());
        }
        return (List)this.inner.remove(key);
    }

    public void putAll(Map<? extends String, ? extends List<V>> m) {
        for (String string : m.keySet()) {
            this.observe(string);
        }
        this.inner.putAll(m);
    }

    public void clear() {
        this.observeAll();
        this.inner.clear();
    }

    public Set<String> keySet() {
        return this.inner.keySet();
    }

    public Collection<List<V>> values() {
        this.observeAll();
        return this.inner.values();
    }

    public Set<Map.Entry<String, List<V>>> entrySet() {
        this.observeAll();
        return this.inner.entrySet();
    }

    public void setGuard(String key) {
        this.guards.put(key, false);
    }

    public Set<String> getGuards() {
        return this.guards.keySet();
    }

    public boolean isObservedAndReset(String key) {
        Boolean observed = this.guards.get(key);
        if (observed != null) {
            this.guards.put(key, false);
        }
        return observed != null && observed != false;
    }

    private void observe(String key) {
        for (Map.Entry<String, Boolean> guard : this.guards.entrySet()) {
            if (!guard.getKey().equals(key)) continue;
            guard.setValue(true);
            break;
        }
    }

    private void observeAll() {
        for (Map.Entry<String, Boolean> guard : this.guards.entrySet()) {
            guard.setValue(true);
        }
    }

    public String toString() {
        return this.inner.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuardianStringKeyMultivaluedMap that = (GuardianStringKeyMultivaluedMap)o;
        return this.inner.equals(that.inner) && this.guards.equals(that.guards);
    }

    public int hashCode() {
        return Objects.hash(this.inner, this.guards);
    }

    private static class GuardianListIterator<V>
    extends GuardianIterator<V>
    implements ListIterator<V> {
        public GuardianListIterator(Iterator<V> guarded, Map.Entry<String, Boolean> guard) {
            super(guarded, guard);
        }

        @Override
        public boolean hasPrevious() {
            return ((ListIterator)this.guarded).hasPrevious();
        }

        @Override
        public V previous() {
            return (V)this.guardMutable(((ListIterator)this.guarded).previous());
        }

        @Override
        public int nextIndex() {
            return ((ListIterator)this.guarded).nextIndex();
        }

        @Override
        public int previousIndex() {
            return ((ListIterator)this.guarded).previousIndex();
        }

        @Override
        public void set(V v) {
            ((ListIterator)this.guarded).set(v);
            this.guard.setValue(true);
        }

        @Override
        public void add(V v) {
            ((ListIterator)this.guarded).add(v);
            this.guard.setValue(true);
        }
    }

    private static class GuardianIterator<V>
    extends MutableGuardian<V>
    implements Iterator<V> {
        protected final Iterator<V> guarded;

        public GuardianIterator(Iterator<V> guarded, Map.Entry<String, Boolean> guard) {
            super(guard);
            this.guarded = guarded;
        }

        @Override
        public boolean hasNext() {
            return this.guarded.hasNext();
        }

        @Override
        public V next() {
            return this.guardMutable(this.guarded.next());
        }

        @Override
        public void remove() {
            this.guard.setValue(true);
            this.guarded.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            this.guarded.forEachRemaining(action);
        }

        public String toString() {
            return this.guarded.toString();
        }
    }

    private static class GuardianList<V>
    extends MutableGuardian<V>
    implements List<V> {
        private final List<V> guarded;

        public GuardianList(List<V> guarded, Map.Entry<String, Boolean> guard) {
            super(guard);
            this.guarded = guarded;
        }

        @Override
        public int size() {
            return this.guarded.size();
        }

        @Override
        public boolean isEmpty() {
            return this.guarded.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.guarded.contains(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new GuardianIterator<V>(this.guarded.iterator(), this.guard);
        }

        @Override
        public Object[] toArray() {
            this.guard.setValue(true);
            return this.guarded.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            this.guard.setValue(true);
            return this.guarded.toArray(a);
        }

        @Override
        public boolean add(V e) {
            this.guard.setValue(true);
            return this.guarded.add(e);
        }

        @Override
        public boolean remove(Object o) {
            this.guard.setValue(true);
            return this.guarded.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.guarded.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            this.guard.setValue(true);
            return this.guarded.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> c) {
            this.guard.setValue(true);
            return this.guarded.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.guard.setValue(true);
            return this.guarded.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.guard.setValue(true);
            return this.guarded.retainAll(c);
        }

        @Override
        public void clear() {
            this.guard.setValue(true);
            this.guarded.clear();
        }

        @Override
        public V get(int index) {
            return this.guardMutable(this.guarded.get(index));
        }

        @Override
        public V set(int index, V element) {
            this.guard.setValue(true);
            return this.guarded.set(index, element);
        }

        @Override
        public void add(int index, V element) {
            this.guard.setValue(true);
            this.guarded.add(index, element);
        }

        @Override
        public V remove(int index) {
            this.guard.setValue(true);
            return this.guarded.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.guarded.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.guarded.lastIndexOf(o);
        }

        @Override
        public ListIterator<V> listIterator() {
            return new GuardianListIterator<V>(this.guarded.listIterator(), this.guard);
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            return new GuardianListIterator<V>(this.guarded.listIterator(index), this.guard);
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            GuardianList<V> sublist = this.guarded.subList(fromIndex, toIndex);
            return sublist != null ? new GuardianList<V>(sublist, this.guard) : sublist;
        }

        public String toString() {
            return this.guarded.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (GuardianList.class.isInstance(obj)) {
                return this.guarded.equals(((GuardianList)obj).guarded);
            }
            return this.guarded.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.guarded.hashCode();
        }
    }

    private static class MutableGuardian<V> {
        protected final Map.Entry<String, Boolean> guard;

        private MutableGuardian(Map.Entry<String, Boolean> guard) {
            this.guard = guard;
        }

        protected V guardMutable(V mutable) {
            if (GuardianStringKeyMultivaluedMap.isMutable(mutable)) {
                this.guard.setValue(true);
            }
            return mutable;
        }
    }
}

