/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.enums.EncryptionType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.chunk.AbstractChunkReader;
import org.apache.tsfile.read.reader.page.LazyLoadPageData;
import org.apache.tsfile.read.reader.page.PageReader;

public class ChunkReader
extends AbstractChunkReader {
    private final ChunkHeader chunkHeader;
    private final ByteBuffer chunkDataBuffer;
    private final List<TimeRange> deleteIntervalList;
    private final EncryptParameter encryptParam;

    public ChunkReader(Chunk chunk, long readStopTime, Filter queryFilter) {
        super(readStopTime, queryFilter);
        this.chunkHeader = chunk.getHeader();
        this.chunkDataBuffer = chunk.getData();
        this.deleteIntervalList = chunk.getDeleteIntervalList();
        this.encryptParam = chunk.getEncryptParam();
        this.initAllPageReaders(chunk.getChunkStatistic());
    }

    public ChunkReader(Chunk chunk) throws IOException {
        this(chunk, Long.MIN_VALUE, null);
    }

    public ChunkReader(Chunk chunk, Filter queryFilter) {
        this(chunk, Long.MIN_VALUE, queryFilter);
    }

    public ChunkReader(Chunk chunk, long readStopTime) {
        this(chunk, readStopTime, null);
    }

    private void initAllPageReaders(Statistics<? extends Serializable> chunkStatistic) {
        while (this.chunkDataBuffer.remaining() > 0) {
            PageHeader pageHeader;
            if ((byte)(this.chunkHeader.getChunkType() & 0x3F) == 5) {
                pageHeader = PageHeader.deserializeFrom(this.chunkDataBuffer, chunkStatistic);
            } else {
                pageHeader = PageHeader.deserializeFrom(this.chunkDataBuffer, this.chunkHeader.getDataType());
                if (this.pageCanSkip(pageHeader)) {
                    this.skipCurrentPage(pageHeader);
                    continue;
                }
            }
            if (this.pageDeleted(pageHeader)) {
                this.skipCurrentPage(pageHeader);
                continue;
            }
            this.pageReaderList.add(this.constructPageReader(pageHeader));
        }
    }

    private boolean pageCanSkip(PageHeader pageHeader) {
        return this.queryFilter != null && !this.queryFilter.satisfyStartEndTime(pageHeader.getStartTime(), pageHeader.getEndTime());
    }

    protected boolean pageDeleted(PageHeader pageHeader) {
        if (this.readStopTime > pageHeader.getEndTime()) {
            return true;
        }
        long startTime = pageHeader.getStartTime();
        long endTime = pageHeader.getEndTime();
        if (this.deleteIntervalList != null) {
            for (TimeRange range : this.deleteIntervalList) {
                if (range.contains(startTime, endTime)) {
                    return true;
                }
                if (!range.overlaps(new TimeRange(startTime, endTime))) continue;
                pageHeader.setModified(true);
            }
        }
        return false;
    }

    private void skipCurrentPage(PageHeader pageHeader) {
        this.chunkDataBuffer.position(this.chunkDataBuffer.position() + pageHeader.getCompressedSize());
    }

    private PageReader constructPageReader(PageHeader pageHeader) {
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor(this.chunkHeader.getCompressionType());
        int currentPagePosition = this.chunkDataBuffer.position();
        this.skipCurrentPage(pageHeader);
        PageReader reader = new PageReader(pageHeader, new LazyLoadPageData(this.chunkDataBuffer.array(), currentPagePosition, unCompressor, this.encryptParam), this.chunkHeader.getDataType(), Decoder.getDecoderByType(this.chunkHeader.getEncodingType(), this.chunkHeader.getDataType()), this.defaultTimeDecoder, this.queryFilter);
        reader.setDeleteIntervalList(this.deleteIntervalList);
        return reader;
    }

    public static ByteBuffer readCompressedPageData(PageHeader pageHeader, ByteBuffer chunkBuffer) throws IOException {
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        byte[] compressedPageBody = new byte[compressedPageBodyLength];
        if (compressedPageBodyLength > chunkBuffer.remaining()) {
            throw new IOException("do not has a complete page body. Expected:" + compressedPageBodyLength + ". Actual:" + chunkBuffer.remaining());
        }
        chunkBuffer.get(compressedPageBody);
        return ByteBuffer.wrap(compressedPageBody);
    }

    public static ByteBuffer uncompressPageData(PageHeader pageHeader, IUnCompressor unCompressor, ByteBuffer compressedPageData) throws IOException {
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        byte[] uncompressedPageData = new byte[pageHeader.getUncompressedSize()];
        try {
            unCompressor.uncompress(compressedPageData.array(), compressedPageData.arrayOffset() + compressedPageData.position(), compressedPageBodyLength, uncompressedPageData, 0);
        }
        catch (Exception e) {
            throw new IOException("Uncompress error! uncompress size: " + pageHeader.getUncompressedSize() + "compressed size: " + pageHeader.getCompressedSize() + "page header: " + pageHeader + e.getMessage(), e);
        }
        compressedPageData.position(compressedPageData.position() + compressedPageBodyLength);
        return ByteBuffer.wrap(uncompressedPageData);
    }

    public static ByteBuffer decryptAndUncompressPageData(PageHeader pageHeader, IUnCompressor unCompressor, ByteBuffer compressedPageData, IDecryptor decryptor) throws IOException {
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        byte[] uncompressedPageData = new byte[pageHeader.getUncompressedSize()];
        try {
            byte[] decryptedPageData = decryptor.decrypt(compressedPageData.array(), compressedPageData.arrayOffset() + compressedPageData.position(), compressedPageBodyLength);
            unCompressor.uncompress(decryptedPageData, 0, compressedPageBodyLength, uncompressedPageData, 0);
        }
        catch (Exception e) {
            throw new IOException("Uncompress error! uncompress size: " + pageHeader.getUncompressedSize() + "compressed size: " + pageHeader.getCompressedSize() + "page header: " + pageHeader + e.getMessage(), e);
        }
        compressedPageData.position(compressedPageData.position() + compressedPageBodyLength);
        return ByteBuffer.wrap(uncompressedPageData);
    }

    public static ByteBuffer deserializePageData(PageHeader pageHeader, ByteBuffer chunkBuffer, ChunkHeader chunkHeader, IDecryptor decryptor) throws IOException {
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor(chunkHeader.getCompressionType());
        ByteBuffer compressedPageBody = ChunkReader.readCompressedPageData(pageHeader, chunkBuffer);
        if (decryptor == null || decryptor.getEncryptionType() == EncryptionType.UNENCRYPTED) {
            return ChunkReader.uncompressPageData(pageHeader, unCompressor, compressedPageBody);
        }
        return ChunkReader.decryptAndUncompressPageData(pageHeader, unCompressor, compressedPageBody, decryptor);
    }

    public static ByteBuffer deserializePageData(PageHeader pageHeader, ByteBuffer chunkBuffer, ChunkHeader chunkHeader) throws IOException {
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor(chunkHeader.getCompressionType());
        ByteBuffer compressedPageBody = ChunkReader.readCompressedPageData(pageHeader, chunkBuffer);
        return ChunkReader.uncompressPageData(pageHeader, unCompressor, compressedPageBody);
    }
}

