/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeStatement;

public class CreatePipePlugin
extends PipeStatement {
    private final String pluginName;
    private final boolean ifNotExistsCondition;
    private final String className;
    private final String uriString;

    public CreatePipePlugin(String pluginName, boolean ifNotExistsCondition, String className, String uriString) {
        this.pluginName = Objects.requireNonNull(pluginName, "plugin name can not be null");
        this.ifNotExistsCondition = ifNotExistsCondition;
        this.className = Objects.requireNonNull(className, "class name can not be null");
        this.uriString = Objects.requireNonNull(uriString, "uri can not be null");
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean hasIfNotExistsCondition() {
        return this.ifNotExistsCondition;
    }

    public String getClassName() {
        return this.className;
    }

    public String getUriString() {
        return this.uriString;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreatePipePlugin(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pluginName, this.ifNotExistsCondition, this.className, this.uriString);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreatePipePlugin other = (CreatePipePlugin)obj;
        return Objects.equals(this.pluginName, other.pluginName) && Objects.equals(this.ifNotExistsCondition, other.ifNotExistsCondition) && Objects.equals(this.className, other.className) && Objects.equals(this.uriString, other.uriString);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pluginName", (Object)this.pluginName).add("ifNotExistsCondition", this.ifNotExistsCondition).add("className", (Object)this.className).add("uriString", (Object)this.uriString).toString();
    }
}

