/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.AbstractGreatestLeastColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class FloatGreatestColumnTransformer
extends AbstractGreatestLeastColumnTransformer {
    protected FloatGreatestColumnTransformer(Type returnType, List<ColumnTransformer> columnTransformerList) {
        super(returnType, columnTransformerList);
    }

    @Override
    protected void transform(ColumnBuilder builder, List<Column> childrenColumns, int index) {
        Column firstColumn = childrenColumns.get(0);
        float maxValue = firstColumn.getFloat(index);
        boolean allNull = firstColumn.isNull(index);
        for (int i = 1; i < childrenColumns.size(); ++i) {
            Column column = childrenColumns.get(i);
            if (column.isNull(index)) continue;
            float value = column.getFloat(index);
            if (!allNull && !(value > maxValue)) continue;
            allNull = false;
            maxValue = value;
        }
        if (allNull) {
            builder.appendNull();
        } else {
            this.returnType.writeFloat(builder, maxValue);
        }
    }
}

