/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;

public class NullLiteral
extends Literal {
    public NullLiteral() {
        super(null);
    }

    public NullLiteral(NodeLocation location) {
        super(Objects.requireNonNull(location, "location is null"));
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNullLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return NullLiteral.sameClass(this, other);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.NULL_LITERAL;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
    }

    public NullLiteral(ByteBuffer byteBuffer) {
        super(null);
    }

    @Override
    public Object getTsValue() {
        return null;
    }
}

