/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.util.List;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.CoreDataModule;
import org.apache.james.DefaultVacationService;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.dlp.eventsourcing.EventSourcingDLPConfigurationStore;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.mailrepository.api.MailRepositoryFactory;
import org.apache.james.mailrepository.api.MailRepositoryUrlStore;
import org.apache.james.mailrepository.api.Protocol;
import org.apache.james.mailrepository.memory.MailRepositoryStoreConfiguration;
import org.apache.james.mailrepository.memory.MemoryMailRepository;
import org.apache.james.mailrepository.memory.MemoryMailRepositoryFactory;
import org.apache.james.mailrepository.memory.MemoryMailRepositoryUrlStore;
import org.apache.james.modules.data.SieveFileRepositoryModule;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.lib.AliasReverseResolverImpl;
import org.apache.james.rrt.lib.CanSendFromImpl;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.util.date.DefaultZonedDateTimeProvider;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.vacation.api.NotificationRegistry;
import org.apache.james.vacation.api.VacationDeleteUserTaskStep;
import org.apache.james.vacation.api.VacationRepository;
import org.apache.james.vacation.api.VacationService;
import org.apache.james.vacation.memory.MemoryNotificationRegistry;
import org.apache.james.vacation.memory.MemoryVacationRepository;

public class MemoryDataModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new SieveFileRepositoryModule());
        this.install((Module)new CoreDataModule());
        this.bind(EventSourcingDLPConfigurationStore.class).in(Scopes.SINGLETON);
        this.bind(DLPConfigurationStore.class).to(EventSourcingDLPConfigurationStore.class);
        this.bind(MemoryDomainList.class).in(Scopes.SINGLETON);
        this.bind(DomainList.class).to(MemoryDomainList.class);
        this.bind(MemoryRecipientRewriteTable.class).in(Scopes.SINGLETON);
        this.bind(RecipientRewriteTable.class).to(MemoryRecipientRewriteTable.class);
        this.bind(AliasReverseResolverImpl.class).in(Scopes.SINGLETON);
        this.bind(AliasReverseResolver.class).to(AliasReverseResolverImpl.class);
        this.bind(CanSendFromImpl.class).in(Scopes.SINGLETON);
        this.bind(CanSendFrom.class).to(CanSendFromImpl.class);
        this.bind(MemoryMailRepositoryUrlStore.class).in(Scopes.SINGLETON);
        this.bind(MailRepositoryUrlStore.class).to(MemoryMailRepositoryUrlStore.class);
        this.bind(EventSourcingDLPConfigurationStore.class).in(Scopes.SINGLETON);
        this.bind(DLPConfigurationStore.class).to(EventSourcingDLPConfigurationStore.class);
        this.bind(DefaultVacationService.class).in(Scopes.SINGLETON);
        this.bind(VacationService.class).to(DefaultVacationService.class);
        this.bind(MemoryVacationRepository.class).in(Scopes.SINGLETON);
        this.bind(VacationRepository.class).to(MemoryVacationRepository.class);
        this.bind(MemoryNotificationRegistry.class).in(Scopes.SINGLETON);
        this.bind(NotificationRegistry.class).to(MemoryNotificationRegistry.class);
        this.bind(DefaultZonedDateTimeProvider.class).in(Scopes.SINGLETON);
        this.bind(ZonedDateTimeProvider.class).to(DefaultZonedDateTimeProvider.class);
        this.bind(MailRepositoryStoreConfiguration.Item.class).toProvider(() -> new MailRepositoryStoreConfiguration.Item((List)ImmutableList.of((Object)new Protocol("memory")), MemoryMailRepository.class.getName(), (HierarchicalConfiguration)new BaseHierarchicalConfiguration()));
        Multibinder.newSetBinder((Binder)this.binder(), MailRepositoryFactory.class).addBinding().to(MemoryMailRepositoryFactory.class);
        Multibinder deleteUserDataTaskSteps = Multibinder.newSetBinder((Binder)this.binder(), DeleteUserDataTaskStep.class);
        deleteUserDataTaskSteps.addBinding().to(VacationDeleteUserTaskStep.class);
    }

    @ProvidesIntoSet
    InitializationOperation configureDomainList(DomainListConfiguration domainListConfiguration, MemoryDomainList memoryDomainList) {
        return InitilizationOperationBuilder.forClass(MemoryDomainList.class).init(() -> memoryDomainList.configure(domainListConfiguration));
    }

    @ProvidesIntoSet
    InitializationOperation configureRRT(ConfigurationProvider configurationProvider, MemoryRecipientRewriteTable memoryRecipientRewriteTable) {
        return InitilizationOperationBuilder.forClass(MemoryRecipientRewriteTable.class).init(() -> memoryRecipientRewriteTable.configure(configurationProvider.getConfiguration("recipientrewritetable")));
    }
}

