/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.standard;

import com.github.f4b6a3.uuid.enums.UuidLocalDomain;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstTimeBasedFactory;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public final class DceSecurityFactory
extends AbstTimeBasedFactory {
    private AtomicInteger counter;
    private final byte localDomain;

    public DceSecurityFactory() {
        this(DceSecurityFactory.builder());
    }

    private DceSecurityFactory(Builder builder) {
        super(UuidVersion.VERSION_DCE_SECURITY, builder);
        this.localDomain = builder.localDomain;
        this.counter = new AtomicInteger();
    }

    public static Builder builder() {
        return new Builder();
    }

    public UUID create(byte localDomain, int localIdentifier) {
        UUID uuid = super.create();
        long lsb = DceSecurityFactory.embedLocalDomain(uuid.getLeastSignificantBits(), localDomain, this.counter.incrementAndGet());
        long msb = DceSecurityFactory.emgedLocalIdentifier(uuid.getMostSignificantBits(), localIdentifier);
        return this.toUuid(msb, lsb);
    }

    public UUID create(UuidLocalDomain localDomain, int localIdentifier) {
        return this.create(localDomain.getValue(), localIdentifier);
    }

    public UUID create(int localIdentifier) {
        return this.create(this.localDomain, localIdentifier);
    }

    @Override
    public UUID create() {
        throw new UnsupportedOperationException("Unsuported operation for DCE Security UUID factory");
    }

    @Override
    public UUID create(UuidFactory.Parameters parameters) {
        return this.create(parameters.getLocalDomain(), parameters.getLocalIdentifier());
    }

    private static long emgedLocalIdentifier(long msb, int localIdentifier) {
        return msb & 0xFFFFFFFFL | ((long)localIdentifier & 0xFFFFFFFFL) << 32;
    }

    private static long embedLocalDomain(long lsb, byte localDomain, long counter) {
        return lsb & 0xFFFFFFFFFFFFL | ((long)localDomain & 0xFFL) << 48 | (counter & 0xFFL) << 56;
    }

    public static class Builder
    extends AbstTimeBasedFactory.Builder<DceSecurityFactory, Builder> {
        private byte localDomain;

        public Builder withLocalDomain(UuidLocalDomain localDomain) {
            this.localDomain = localDomain.getValue();
            return this;
        }

        public Builder withLocalDomain(byte localDomain) {
            this.localDomain = localDomain;
            return this;
        }

        @Override
        public DceSecurityFactory build() {
            return new DceSecurityFactory(this);
        }
    }
}

