/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.loader.ClassFactory;

class ApplicationObjectInputStream
extends ObjectInputStream
implements ErrorObjectInput {
    protected ClassFactory cf;
    protected ObjectStreamClass initialClass;

    ApplicationObjectInputStream(InputStream inputStream, ClassFactory classFactory) throws IOException {
        super(inputStream);
        this.cf = classFactory;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (this.initialClass == null) {
            this.initialClass = objectStreamClass;
        }
        if (this.cf != null) {
            return this.cf.loadApplicationClass(objectStreamClass);
        }
        throw new ClassNotFoundException(objectStreamClass.getName());
    }

    @Override
    public String getErrorInfo() {
        if (this.initialClass == null) {
            return "";
        }
        return this.initialClass.getName() + " (serialVersionUID=" + this.initialClass.getSerialVersionUID() + ")";
    }

    @Override
    public Exception getNestedException() {
        return null;
    }
}

