/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.table.TableData;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.join.ImmutableUniqueList;

public class TableBuilder {
    private ImmutableUniqueList.Builder<Var> varsBuilder = ImmutableUniqueList.newUniqueListBuilder(Var.class);
    private List<Binding> rows = new ArrayList<Binding>();
    private boolean copyRowsOnNextMutation = false;

    public List<Var> snapshotVars() {
        return this.varsBuilder.build();
    }

    public int sizeVars() {
        return this.varsBuilder.size();
    }

    public TableBuilder addVar(Var var) {
        this.varsBuilder.add(var);
        return this;
    }

    public TableBuilder addVars(Collection<Var> vars) {
        this.varsBuilder.addAll(vars);
        return this;
    }

    public TableBuilder addVars(Iterator<Var> vars) {
        vars.forEachRemaining(this.varsBuilder::add);
        return this;
    }

    public TableBuilder addVarsFromRow(Binding row) {
        row.vars().forEachRemaining(this.varsBuilder::add);
        return this;
    }

    private void copyRowsIfNeeded() {
        if (this.copyRowsOnNextMutation) {
            this.rows = new ArrayList<Binding>(this.rows);
            this.copyRowsOnNextMutation = false;
        }
    }

    public List<Binding> snapshotRows() {
        return List.copyOf(this.rows);
    }

    public int sizeRows() {
        return this.rows.size();
    }

    public TableBuilder addRow(Binding row) {
        this.copyRowsIfNeeded();
        this.rows.add(row);
        return this;
    }

    public TableBuilder addRows(Collection<Binding> newRows) {
        this.copyRowsIfNeeded();
        this.rows.addAll(newRows);
        return this;
    }

    public TableBuilder addRows(Iterator<Binding> newRows) {
        this.copyRowsIfNeeded();
        newRows.forEachRemaining(this.rows::add);
        return this;
    }

    private void addRowAndVarsInternal(Binding row) {
        this.addVarsFromRow(row);
        this.rows.add(row);
    }

    public TableBuilder addRowAndVars(Binding row) {
        this.copyRowsIfNeeded();
        this.addRowAndVarsInternal(row);
        return this;
    }

    public TableBuilder addRowsAndVars(Collection<Binding> newRows) {
        this.copyRowsIfNeeded();
        newRows.forEach(this::addVarsFromRow);
        this.rows.addAll(newRows);
        return this;
    }

    public TableBuilder addRowsAndVars(Iterator<Binding> newRows) {
        this.copyRowsIfNeeded();
        newRows.forEachRemaining(this::addRowAndVarsInternal);
        return this;
    }

    public TableBuilder addRowsAndVars(Table table) {
        this.addVars(table.getVars());
        this.addRows(table.rows());
        return this;
    }

    public TableBuilder consumeRowsAndVars(QueryIterator qIter) {
        Objects.requireNonNull(qIter);
        try {
            this.addRowsAndVars((Iterator<Binding>)((Object)qIter));
        }
        finally {
            qIter.close();
        }
        return this;
    }

    public TableBuilder resetVars() {
        this.varsBuilder.clear();
        return this;
    }

    public TableBuilder resetRows() {
        if (this.copyRowsOnNextMutation) {
            this.rows = new ArrayList<Binding>();
            this.copyRowsOnNextMutation = false;
        } else {
            this.rows.clear();
        }
        return this;
    }

    public TableBuilder reset() {
        this.resetVars();
        this.resetRows();
        return this;
    }

    public Table build() {
        List<Var> finalVars = this.snapshotVars();
        List<Binding> finalRows = Collections.unmodifiableList(this.rows);
        this.copyRowsOnNextMutation = true;
        return new TableData(finalVars, finalRows);
    }
}

