/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.vocabulary.SHACL;

public class Severity {
    public static Severity Info = new Severity(SHACL.Info);
    public static Severity Warning = new Severity(SHACL.Warning);
    public static Severity Violation = new Severity(SHACL.Violation);
    private final Node level;

    private Severity(Node uri) {
        this.level = uri;
    }

    public Node level() {
        return this.level;
    }

    public static Severity create(Node n) {
        Objects.requireNonNull(n);
        if (n.equals((Object)SHACL.Violation)) {
            return Violation;
        }
        if (n.equals((Object)SHACL.Warning)) {
            return Warning;
        }
        if (n.equals((Object)SHACL.Info)) {
            return Info;
        }
        if (n.isURI()) {
            return new Severity(n);
        }
        throw new ShaclException("Not a recognized severity: " + ShLib.displayStr(n));
    }

    public int hashCode() {
        return 53 * Objects.hash(this.level);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Severity)) {
            return false;
        }
        Severity other = (Severity)obj;
        return Objects.equals(this.level, other.level);
    }
}

