/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.util.UrlPathInfo;
import org.apache.juneau.rest.util.UrlPathPatternMatch;

@BeanIgnore
public final class UrlPathPattern
implements Comparable<UrlPathPattern> {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");
    private final String pattern;
    private final String comparator;
    private final String[] parts;
    private final String[] vars;
    private final String[] varKeys;
    private final boolean hasRemainder;

    public UrlPathPattern(String patternString) {
        this.pattern = StringUtils.isEmpty(patternString) ? "/" : (patternString.charAt(0) != '/' ? '/' + patternString : patternString);
        String c = patternString.replaceAll("\\{[^\\}]+\\}", ".").replaceAll("\\w+", "X").replaceAll("\\.", "W");
        if (c.isEmpty()) {
            c = "+";
        }
        if (!c.endsWith("/*")) {
            c = c + "/W";
        }
        this.comparator = c;
        String[] parts = new UrlPathInfo(this.pattern).getParts();
        this.hasRemainder = parts.length > 0 && "*".equals(parts[parts.length - 1]);
        parts = this.hasRemainder ? Arrays.copyOf(parts, parts.length - 1) : parts;
        this.parts = parts;
        this.vars = new String[parts.length];
        ArrayList<String> vars = new ArrayList<String>();
        for (int i = 0; i < parts.length; ++i) {
            Matcher m = VAR_PATTERN.matcher(parts[i]);
            if (!m.matches()) continue;
            this.vars[i] = m.group(1);
            vars.add(this.vars[i]);
        }
        this.varKeys = vars.isEmpty() ? null : vars.toArray(new String[vars.size()]);
    }

    public UrlPathPatternMatch match(String path) {
        return this.match(new UrlPathInfo(path));
    }

    public UrlPathPatternMatch match(UrlPathInfo pathInfo) {
        String[] pip = pathInfo.getParts();
        if (this.parts.length != pip.length) {
            if (this.hasRemainder) {
                if (pip.length == this.parts.length - 1 && !pathInfo.isTrailingSlash()) {
                    return null;
                }
                if (pip.length < this.parts.length) {
                    return null;
                }
            } else {
                if (pip.length != this.parts.length + 1) {
                    return null;
                }
                if (!pathInfo.isTrailingSlash()) {
                    return null;
                }
            }
        }
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.vars[i] != null || pip.length > i && ("*".equals(this.parts[i]) || pip[i].equals(this.parts[i]))) continue;
            return null;
        }
        String[] vals = this.varKeys == null ? null : new String[this.varKeys.length];
        int j = 0;
        if (vals != null) {
            for (int i = 0; i < this.parts.length; ++i) {
                if (this.vars[i] == null) continue;
                vals[j++] = pip[i];
            }
        }
        return new UrlPathPatternMatch(pathInfo.getPath(), this.parts.length, this.varKeys, vals);
    }

    public String[] getVars() {
        return this.varKeys == null ? new String[]{} : Arrays.copyOf(this.varKeys, this.varKeys.length);
    }

    public boolean hasVars() {
        return this.varKeys != null;
    }

    @Override
    public int compareTo(UrlPathPattern o) {
        return o.comparator.compareTo(this.comparator);
    }

    public String toString() {
        return this.pattern.toString();
    }
}

