/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.springboot;

import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.BeanStoreEntry;
import org.springframework.context.ApplicationContext;

public class SpringBeanStore
extends BeanStore {
    private final Optional<ApplicationContext> appContext;

    public SpringBeanStore(Optional<ApplicationContext> appContext, Optional<BeanStore> parent, Object resource) {
        super(SpringBeanStore.create().parent((BeanStore)parent.orElse(null)).outer(resource));
        this.appContext = appContext;
    }

    public SpringBeanStore clear() {
        super.clear();
        return this;
    }

    public <T> Optional<T> getBean(Class<T> c) {
        try {
            Optional o = super.getBean(c);
            if (o.isPresent()) {
                return o;
            }
            if (this.appContext.isPresent()) {
                return Utils.opt((Object)this.appContext.get().getBeanProvider(c).getIfAvailable());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Utils.opte();
    }

    public <T> Optional<T> getBean(Class<T> c, String name) {
        try {
            Optional o = super.getBean(c, name);
            if (o.isPresent()) {
                return o;
            }
            if (this.appContext.isPresent()) {
                ApplicationContext ctx = this.appContext.get();
                if (Utils.nn((Object)name)) {
                    return Utils.opt(ctx.containsBean(name) ? this.appContext.get().getBean(name, c) : null);
                }
                return Utils.opt((Object)this.appContext.get().getBean(c));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Utils.opte();
    }

    public SpringBeanStore removeBean(Class<?> beanType) {
        super.removeBean(beanType);
        return this;
    }

    public SpringBeanStore removeBean(Class<?> beanType, String name) {
        super.removeBean(beanType, name);
        return this;
    }

    public <T> Stream<BeanStoreEntry<T>> stream(Class<T> c) {
        try {
            Stream<BeanStoreEntry> o = super.stream(c);
            if (this.appContext.isPresent()) {
                o = Stream.concat(o, this.appContext.get().getBeansOfType(c).entrySet().stream().map(x -> BeanStoreEntry.create((Class)c, () -> x.getValue(), (String)((String)x.getKey()))));
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList().stream().map(x -> (BeanStoreEntry)x);
        }
    }
}

