/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BasicPropertyNamer;
import org.apache.juneau.BeanContext;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.BeanInterceptor;

public class BeanAnnotation {
    public static final Bean DEFAULT = BeanAnnotation.create().build();

    public static Bean copy(Bean a, VarResolverSession r) {
        return BeanAnnotation.create().dictionary(a.dictionary()).example(r.resolve(a.example())).excludeProperties(r.resolve(a.excludeProperties())).findFluentSetters(a.findFluentSetters()).implClass(a.implClass()).interceptor(a.interceptor()).interfaceClass(a.interfaceClass()).on(r.resolve(a.on())).onClass((Class[])a.onClass()).p(r.resolve(a.p())).properties(r.resolve(a.properties())).propertyNamer(a.propertyNamer()).readOnlyProperties(r.resolve(a.readOnlyProperties())).ro(r.resolve(a.ro())).sort(a.sort()).stopClass(a.stopClass()).typeName(r.resolve(a.typeName())).typePropertyName(r.resolve(a.typePropertyName())).wo(r.resolve(a.wo())).writeOnlyProperties(r.resolve(a.writeOnlyProperties())).xp(r.resolve(a.xp())).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return BeanAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return BeanAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderT {
        private String[] description = new String[0];
        private Class<?>[] dictionary = new Class[0];
        private Class<?> implClass = Void.TYPE;
        private Class<?> interfaceClass = Void.TYPE;
        private Class<?> stopClass = Void.TYPE;
        private Class<? extends BeanInterceptor<?>> interceptor = BeanInterceptor.Void.class;
        private Class<? extends PropertyNamer> propertyNamer = BasicPropertyNamer.class;
        private String example = "";
        private String excludeProperties = "";
        private String p = "";
        private String properties = "";
        private String readOnlyProperties = "";
        private String ro = "";
        private String typeName = "";
        private String typePropertyName = "";
        private String wo = "";
        private String writeOnlyProperties = "";
        private String xp = "";
        private boolean findFluentSetters;
        private boolean sort;

        protected Builder() {
            super(Bean.class);
        }

        public Bean build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder dictionary(Class<?> ... value) {
            this.dictionary = value;
            return this;
        }

        public Builder example(String value) {
            this.example = value;
            return this;
        }

        public Builder excludeProperties(String value) {
            this.excludeProperties = value;
            return this;
        }

        public Builder findFluentSetters(boolean value) {
            this.findFluentSetters = value;
            return this;
        }

        public Builder implClass(Class<?> value) {
            this.implClass = value;
            return this;
        }

        public Builder interceptor(Class<? extends BeanInterceptor<?>> value) {
            this.interceptor = value;
            return this;
        }

        public Builder interfaceClass(Class<?> value) {
            this.interfaceClass = value;
            return this;
        }

        public Builder p(String value) {
            this.p = value;
            return this;
        }

        public Builder properties(String value) {
            this.properties = value;
            return this;
        }

        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            this.propertyNamer = value;
            return this;
        }

        public Builder readOnlyProperties(String value) {
            this.readOnlyProperties = value;
            return this;
        }

        public Builder ro(String value) {
            this.ro = value;
            return this;
        }

        public Builder sort(boolean value) {
            this.sort = value;
            return this;
        }

        public Builder stopClass(Class<?> value) {
            this.stopClass = value;
            return this;
        }

        public Builder typeName(String value) {
            this.typeName = value;
            return this;
        }

        public Builder typePropertyName(String value) {
            this.typePropertyName = value;
            return this;
        }

        public Builder wo(String value) {
            this.wo = value;
            return this;
        }

        public Builder writeOnlyProperties(String value) {
            this.writeOnlyProperties = value;
            return this;
        }

        public Builder xp(String value) {
            this.xp = value;
            return this;
        }

        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements Bean {
        private final String[] description;
        private final boolean findFluentSetters;
        private final boolean sort;
        private final Class<? extends BeanInterceptor<?>> interceptor;
        private final Class<? extends PropertyNamer> propertyNamer;
        private final Class<?> implClass;
        private final Class<?> interfaceClass;
        private final Class<?> stopClass;
        private final Class<?>[] dictionary;
        private final String example;
        private final String excludeProperties;
        private final String p;
        private final String properties;
        private final String readOnlyProperties;
        private final String ro;
        private final String typeName;
        private final String typePropertyName;
        private final String wo;
        private final String writeOnlyProperties;
        private final String xp;

        Object(Builder b) {
            super((AppliedAnnotationObject.BuilderT)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.dictionary = (Class[])CollectionUtils.copyOf((java.lang.Object[])b.dictionary);
            this.example = b.example;
            this.excludeProperties = b.excludeProperties;
            this.findFluentSetters = b.findFluentSetters;
            this.implClass = b.implClass;
            this.interceptor = b.interceptor;
            this.interfaceClass = b.interfaceClass;
            this.p = b.p;
            this.properties = b.properties;
            this.propertyNamer = b.propertyNamer;
            this.readOnlyProperties = b.readOnlyProperties;
            this.ro = b.ro;
            this.sort = b.sort;
            this.stopClass = b.stopClass;
            this.typeName = b.typeName;
            this.typePropertyName = b.typePropertyName;
            this.wo = b.wo;
            this.writeOnlyProperties = b.writeOnlyProperties;
            this.xp = b.xp;
        }

        @Override
        public Class<?>[] dictionary() {
            return this.dictionary;
        }

        @Override
        public String example() {
            return this.example;
        }

        @Override
        public String excludeProperties() {
            return this.excludeProperties;
        }

        @Override
        public boolean findFluentSetters() {
            return this.findFluentSetters;
        }

        @Override
        public Class<?> implClass() {
            return this.implClass;
        }

        @Override
        public Class<? extends BeanInterceptor<?>> interceptor() {
            return this.interceptor;
        }

        @Override
        public Class<?> interfaceClass() {
            return this.interfaceClass;
        }

        @Override
        public String p() {
            return this.p;
        }

        @Override
        public String properties() {
            return this.properties;
        }

        @Override
        public Class<? extends PropertyNamer> propertyNamer() {
            return this.propertyNamer;
        }

        @Override
        public String readOnlyProperties() {
            return this.readOnlyProperties;
        }

        @Override
        public String ro() {
            return this.ro;
        }

        @Override
        public boolean sort() {
            return this.sort;
        }

        @Override
        public Class<?> stopClass() {
            return this.stopClass;
        }

        @Override
        public String typeName() {
            return this.typeName;
        }

        @Override
        public String typePropertyName() {
            return this.typePropertyName;
        }

        @Override
        public String wo() {
            return this.wo;
        }

        @Override
        public String writeOnlyProperties() {
            return this.writeOnlyProperties;
        }

        @Override
        public String xp() {
            return this.xp;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Bean[] value();
    }

    public static class Applier
    extends AnnotationApplier<Bean, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Bean.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Bean> ai, BeanContext.Builder b) {
            Bean a = (Bean)ai.inner();
            if (CollectionUtils.isEmptyArray((java.lang.Object[])a.on()) && CollectionUtils.isEmptyArray((java.lang.Object[])a.onClass())) {
                return;
            }
            b.annotations(BeanAnnotation.copy(a, this.vr()));
        }
    }
}

