/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.IOException;
import java.io.Reader;
import org.apache.juneau.commons.io.CharSequenceReader;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.Position;
import org.apache.juneau.parser.Positionable;

public class ParserReader
extends Reader
implements Positionable {
    protected final Reader r;
    private char[] buff;
    private int line = 1;
    private int column;
    private int iCurrent;
    private int iMark = -1;
    private int iEnd;
    private boolean endReached;
    private boolean holesExist;
    private final boolean unbuffered;

    public ParserReader(ParserPipe pipe) throws IOException {
        this.unbuffered = pipe.unbuffered;
        if (pipe.isString()) {
            String in = pipe.getInputAsString();
            this.r = new CharSequenceReader((CharSequence)in);
            this.buff = new char[in.length() < 1024 ? in.length() : 1024];
        } else {
            Reader _r = pipe.getReader();
            if (_r instanceof ParserReader) {
                ParserReader _r2 = (ParserReader)_r;
                this.r = _r2.r;
            } else {
                this.r = _r;
            }
            this.buff = new char[1024];
        }
        pipe.setPositionable(this);
    }

    @Override
    public void close() throws IOException {
    }

    public final ParserReader delete() {
        return this.delete(1);
    }

    public final ParserReader delete(int count) {
        for (int i = 0; i < count; ++i) {
            this.buff[this.iCurrent - i - 1] = 127;
        }
        this.holesExist = true;
        return this;
    }

    public final String getMarked() {
        return this.getMarked(0, 0);
    }

    public final String getMarked(int offsetStart, int offsetEnd) {
        int offset = 0;
        if (this.holesExist) {
            for (int i = this.iMark; i < this.iCurrent; ++i) {
                char c = this.buff[i];
                if (c == '\u007f') {
                    ++offset;
                    continue;
                }
                this.buff[i - offset] = c;
            }
            this.holesExist = false;
        }
        int start = this.iMark + offsetStart;
        int len = this.iCurrent - this.iMark + offsetEnd - offsetStart - offset;
        String s = new String(this.buff, start, len);
        this.iMark = -1;
        return s;
    }

    @Override
    public Position getPosition() {
        return new Position(this.line, this.column);
    }

    public final void mark() {
        this.iMark = this.iCurrent;
    }

    public String parseNumberString() throws IOException {
        this.mark();
        int c = 0;
        while ((c = this.read()) != -1) {
            if (StringUtils.isNumberChar((char)((char)c))) continue;
            this.unread();
            break;
        }
        return this.getMarked();
    }

    public final int peek() throws IOException {
        int c = this.read();
        if (c != -1) {
            this.unread();
        }
        return c;
    }

    public final int peekSkipWs() throws IOException {
        int c;
        boolean isWs;
        do {
            c = this.read();
            isWs = Character.isWhitespace(c);
            if (c == -1 || isWs) continue;
            this.unread();
        } while (isWs);
        return c;
    }

    @Override
    public final int read() throws IOException {
        int c = this.readFromBuff();
        if (c == -1) {
            return -1;
        }
        if (c == 10) {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.unbuffered ? this.r.read(cbuf, off, 1) : this.r.read(cbuf, off, len);
    }

    public final String read(int num) throws IOException {
        char[] c = new char[num];
        for (int i = 0; i < num; ++i) {
            int c2 = this.read();
            if (c2 == -1) {
                return new String(c, 0, i);
            }
            c[i] = (char)c2;
        }
        return new String(c);
    }

    public final int readCodePoint() throws IOException {
        int low;
        int c = this.read();
        if (c >= 55296 && c <= 56319 && (low = this.read()) >= 56320 && low <= 57343) {
            c = 65536 + (c - 55296 << 10) + (low - 56320);
        }
        return c;
    }

    public final int readSkipWs() throws IOException {
        int c;
        while ((c = this.read()) != -1 && Character.isWhitespace(c)) {
        }
        return c;
    }

    public final ParserReader replace(char c) throws IOException {
        return this.replace(c, 1);
    }

    public final ParserReader replace(int c, int offset) throws IOException {
        if (c < 65536) {
            if (offset < 1) {
                throw ThrowableUtils.ioex((String)"Buffer underflow.", (Object[])new Object[0]);
            }
            this.buff[this.iCurrent - offset] = (char)c;
        } else {
            if (offset < 2) {
                throw ThrowableUtils.ioex((String)"Buffer underflow.", (Object[])new Object[0]);
            }
            this.buff[this.iCurrent - offset] = (char)(55296 + ((c -= 65536) >> 10));
            this.buff[this.iCurrent - offset + 1] = (char)(56320 + (c & 0x3FF));
            --offset;
        }
        for (int i = 1; i < offset; ++i) {
            this.buff[this.iCurrent - i] = 127;
        }
        this.holesExist |= offset > 1;
        return this;
    }

    public ParserReader unread() throws IOException {
        if (this.iCurrent <= 0) {
            throw ThrowableUtils.ioex((String)"Buffer underflow.", (Object[])new Object[0]);
        }
        --this.iCurrent;
        if (this.column == 0) {
            --this.line;
        } else {
            --this.column;
        }
        return this;
    }

    private final int readFromBuff() throws IOException {
        while (this.iCurrent >= this.iEnd) {
            int copyBuff;
            if (this.endReached) {
                return -1;
            }
            if (this.iEnd + 1 < this.buff.length) {
                int x = this.read(this.buff, this.iCurrent, this.buff.length - this.iEnd);
                if (x == -1) {
                    this.endReached = true;
                    return -1;
                }
                this.iEnd += x;
                continue;
            }
            if (this.iMark >= 0) {
                if (this.iMark == 0) {
                    char[] buff2 = new char[this.buff.length << 1];
                    System.arraycopy(this.buff, 0, buff2, 0, this.buff.length);
                    this.buff = buff2;
                } else {
                    copyBuff = this.iMark;
                    System.arraycopy(this.buff, copyBuff, this.buff, 0, this.buff.length - copyBuff);
                    this.iCurrent -= copyBuff;
                    this.iMark -= copyBuff;
                }
                int expected = this.buff.length - this.iCurrent;
                int x = this.read(this.buff, this.iCurrent, expected);
                if (x == -1) {
                    this.endReached = true;
                    this.iEnd = this.iCurrent;
                    return -1;
                }
                this.iEnd = this.iCurrent + x;
                continue;
            }
            copyBuff = Math.min(this.iCurrent, 10);
            System.arraycopy(this.buff, this.iCurrent - copyBuff, this.buff, 0, copyBuff);
            int expected = this.buff.length - copyBuff;
            int x = this.read(this.buff, copyBuff, expected);
            this.iCurrent = copyBuff;
            if (x == -1) {
                this.endReached = true;
                this.iEnd = this.iCurrent;
                return -1;
            }
            this.iEnd = this.iCurrent + x;
        }
        return this.buff[this.iCurrent++];
    }
}

