/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.pool.transx;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSRuntimeException;
import javax.resource.spi.TransactionSupport;
import org.ops4j.pax.jms.service.ConnectionFactoryFactory;
import org.ops4j.pax.jms.service.PooledConnectionFactoryFactory;
import org.ops4j.pax.jms.service.internal.BeanConfig;
import org.ops4j.pax.transx.jms.ManagedConnectionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransxPooledConnectionFactoryFactory
implements PooledConnectionFactoryFactory {
    public static final Logger LOG = LoggerFactory.getLogger(TransxPooledConnectionFactoryFactory.class);

    public ConnectionFactory create(ConnectionFactoryFactory cff, Map<String, Object> props) throws JMSRuntimeException {
        try {
            ConnectionFactory cf = cff.createConnectionFactory(BeanConfig.getNonPoolProps(props));
            ConnectionFactory mcf = ManagedConnectionFactoryBuilder.builder().connectionFactory(cf, null).transaction(TransactionSupport.TransactionSupportLevel.NoTransaction).properties(BeanConfig.getPoolProps(props)).build();
            return mcf;
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled connection factory: " + e.getMessage(), e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

