/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.filter;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.JWTMessages;

public class SignatureVerificationCache {
    public static final String TOKENS_VERIFIED_CACHE_MAX = "tokens.verified.cache.max";
    private static final int TOKENS_VERIFIED_CACHE_MAX_DEFAULT = 250;
    static final String DEFAULT_CACHE_ID = "default-cache";
    static JWTMessages log = (JWTMessages)MessagesFactory.get(JWTMessages.class);
    private static final ConcurrentHashMap<String, SignatureVerificationCache> instances = new ConcurrentHashMap();
    private Cache<String, Boolean> verifiedTokens;

    public static SignatureVerificationCache getInstance(String topology, FilterConfig config) {
        String cacheId = topology != null ? topology : DEFAULT_CACHE_ID;
        return instances.computeIfAbsent(cacheId, c -> SignatureVerificationCache.initializeCacheForTopology(cacheId, config));
    }

    private static SignatureVerificationCache initializeCacheForTopology(String topology, FilterConfig config) {
        SignatureVerificationCache cache = new SignatureVerificationCache(config);
        log.initializedSignatureVerificationCache(topology);
        return cache;
    }

    private SignatureVerificationCache(FilterConfig config) {
        this.initializeVerifiedTokensCache(config);
    }

    private void initializeVerifiedTokensCache(FilterConfig config) {
        int maxCacheSize = 250;
        String configValue = config.getInitParameter(TOKENS_VERIFIED_CACHE_MAX);
        if (configValue != null && !configValue.isEmpty()) {
            try {
                maxCacheSize = Integer.parseInt(configValue);
            }
            catch (NumberFormatException e) {
                log.invalidVerificationCacheMaxConfiguration(configValue);
            }
        }
        this.verifiedTokens = Caffeine.newBuilder().maximumSize((long)maxCacheSize).build();
    }

    public boolean hasSignatureBeenVerified(String token) {
        return this.verifiedTokens.getIfPresent((Object)token) != null;
    }

    public void recordSignatureVerification(String token) {
        this.verifiedTokens.put((Object)token, (Object)true);
    }

    public void removeSignatureVerificationRecord(String token) {
        this.verifiedTokens.asMap().remove(token);
    }

    public long getSize() {
        return this.verifiedTokens.estimatedSize();
    }

    public void performMaintenance() {
        this.verifiedTokens.cleanUp();
    }

    public void clear() {
        this.verifiedTokens.asMap().clear();
    }
}

