/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.rtinfo.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultRuntimeInformation
implements RuntimeInformation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final VersionScheme versionScheme;
    private final String mavenVersion;

    @Inject
    public DefaultRuntimeInformation(VersionScheme versionScheme) {
        this.versionScheme = versionScheme;
        this.mavenVersion = this.loadMavenVersion();
    }

    @Override
    public String getMavenVersion() {
        return this.mavenVersion;
    }

    private String loadMavenVersion() {
        Properties props = new Properties();
        String resource = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
        try (InputStream is = DefaultRuntimeInformation.class.getResourceAsStream("/" + resource);){
            if (is != null) {
                props.load(is);
            } else {
                this.logger.warn("Could not locate " + resource + " on classpath, Maven runtime information not available");
            }
        }
        catch (IOException e) {
            String msg = "Could not parse " + resource + ", Maven runtime information not available";
            if (this.logger.isDebugEnabled()) {
                this.logger.warn(msg, (Throwable)e);
            }
            this.logger.warn(msg);
        }
        String version = props.getProperty("version", "").trim();
        if (!version.startsWith("${")) {
            return version;
        }
        return "";
    }

    @Override
    public boolean isMavenVersion(String versionRange) {
        Version current;
        VersionConstraint constraint;
        if (Objects.requireNonNull(versionRange, "versionRange cannot be null").isEmpty()) {
            throw new IllegalArgumentException("versionRange cannot be empty");
        }
        try {
            constraint = this.versionScheme.parseVersionConstraint(versionRange);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try {
            String mavenVersion = this.getMavenVersion();
            if (mavenVersion.isEmpty()) {
                throw new IllegalArgumentException("Could not determine current Maven version");
            }
            current = this.versionScheme.parseVersion(mavenVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalStateException("Could not parse current Maven version: " + e.getMessage(), e);
        }
        if (constraint.getRange() == null) {
            return constraint.getVersion().compareTo((Object)current) <= 0;
        }
        return constraint.containsVersion(current);
    }
}

