/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import jakarta.faces.component.UIComponent;
import java.util.HashMap;
import java.util.Map;

public class CommonEventConstants {
    public static final String COMMON_EVENTS_MARKED = "oam.COMMON_EVENTS_MARKED";
    public static final long ACTION_EVENT = 1L;
    public static final long CLICK_EVENT = 2L;
    public static final long DBLCLICK_EVENT = 4L;
    public static final long MOUSEDOWN_EVENT = 8L;
    public static final long MOUSEUP_EVENT = 16L;
    public static final long MOUSEOVER_EVENT = 32L;
    public static final long MOUSEMOVE_EVENT = 64L;
    public static final long MOUSEOUT_EVENT = 128L;
    public static final long KEYPRESS_EVENT = 256L;
    public static final long KEYDOWN_EVENT = 512L;
    public static final long KEYUP_EVENT = 1024L;
    public static final long FOCUS_EVENT = 2048L;
    public static final long BLUR_EVENT = 4096L;
    public static final long SELECT_EVENT = 8192L;
    public static final long CHANGE_EVENT = 16384L;
    public static final long VALUECHANGE_EVENT = 32768L;
    public static final long LOAD_EVENT = 65536L;
    public static final long UNLOAD_EVENT = 131072L;
    public static final Map<String, Long> COMMON_EVENTS_KEY_BY_NAME = new HashMap<String, Long>(24, 1.0f);

    public static void markEvent(UIComponent component, String name) {
        Long propertyConstant = COMMON_EVENTS_KEY_BY_NAME.get(name);
        if (propertyConstant == null) {
            return;
        }
        Long commonPropertiesSet = (Long)component.getAttributes().get(COMMON_EVENTS_MARKED);
        if (commonPropertiesSet == null) {
            commonPropertiesSet = 0L;
        }
        component.getAttributes().put(COMMON_EVENTS_MARKED, commonPropertiesSet | propertyConstant);
    }

    static {
        COMMON_EVENTS_KEY_BY_NAME.put("change", 16384L);
        COMMON_EVENTS_KEY_BY_NAME.put("select", 8192L);
        COMMON_EVENTS_KEY_BY_NAME.put("click", 2L);
        COMMON_EVENTS_KEY_BY_NAME.put("dblclick", 4L);
        COMMON_EVENTS_KEY_BY_NAME.put("mousedown", 8L);
        COMMON_EVENTS_KEY_BY_NAME.put("mouseup", 16L);
        COMMON_EVENTS_KEY_BY_NAME.put("mouseover", 32L);
        COMMON_EVENTS_KEY_BY_NAME.put("mousemove", 64L);
        COMMON_EVENTS_KEY_BY_NAME.put("mouseout", 128L);
        COMMON_EVENTS_KEY_BY_NAME.put("keypress", 256L);
        COMMON_EVENTS_KEY_BY_NAME.put("keydown", 512L);
        COMMON_EVENTS_KEY_BY_NAME.put("keyup", 1024L);
        COMMON_EVENTS_KEY_BY_NAME.put("focus", 2048L);
        COMMON_EVENTS_KEY_BY_NAME.put("blur", 4096L);
        COMMON_EVENTS_KEY_BY_NAME.put("load", 65536L);
        COMMON_EVENTS_KEY_BY_NAME.put("unload", 131072L);
        COMMON_EVENTS_KEY_BY_NAME.put("valueChange", 32768L);
        COMMON_EVENTS_KEY_BY_NAME.put("action", 1L);
    }
}

